/**
 * $Id$
 *
 * Copyright (c) 2008 by Oliver Boehm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express orimplied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * (c)reated 13.04.2008 by oliver (ob@oasd.de)
 */
package de.aosd;

import static org.junit.Assert.*;

import java.net.UnknownHostException;

import org.junit.*;

/**
 * @author <a href="boehm@javatux.de">oliver</a>
 * @since 13.04.2008
 * @version $Revision$
 */
public class PortScannerTest {

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * Test method for {@link de.aosd.PortScanner#isActive(java.lang.String, int)}.
	 * @throws UnknownHostException 
	 */
	@Test
	public void testIsActive() throws UnknownHostException {
		assertTrue(PortScanner.isActive("www.heise.de", 80));
	}
	
	@Test
	public void testIsInActive() throws UnknownHostException {
		assertFalse(PortScanner.isActive("localhost", 20));
	}

}

/**
 * $Log$
 * $Source$
 */
