package onlinerechner;

import java.math.BigDecimal;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

/**
 * Diese Form nimmt die Usereingaben an, validiert die Eingabewerte und mappt
 * die Werte in die Memeber der Klasse Zinsen
 * 
 * @author martin
 */
public class ZinsForm extends ActionForm {

	private static final long serialVersionUID = 6207905420568364815L;

	/**
	 * Referenz auf die eigentliche Verarbeitung der Eingabewerte.
	 */
	private Zinsen zinsen = new Zinsen();

	/**
	 * 
	 * @param zinsen
	 */
	public void setZinsen(Zinsen zinsen) {
		this.zinsen = zinsen;
	}

	/**
	 * 
	 * @return Zinsen
	 */
	public Zinsen getZinsen() {
		return this.zinsen;
	}
	
	/**
	 * Kopiert den Betrag aus der Eingabemaske in das Feld Betrag der Klasse
	 * Zinsen.
	 * 
	 * @param betrag
	 *            aus der Eingabemaske
	 */
	public void setBetrag(double betrag) {
		zinsen.setBetrag(betrag);
	}

	/**
	 * Liefert den Betrag aus der Klasse Zinsen.
	 * 
	 * @return Einzahlungsbetrag
	 */
	public double getBetrag() {
		return zinsen.getBetrag();
	}

	/**
	 * Kopiert die Laufzeit aus der Eingabemaske in das Feld Laufzeit der Klasse
	 * Zinsen.
	 * 
	 * @param laufzeit der Zinsanlage.	   
	 */
	public void setLaufzeit(double laufzeit) {
		zinsen.setLaufzeit(laufzeit);
	}

	/**
	 * Liefert die Laufzeit aus der Klasse Zinsen.
	 * 
	 * @return laufzeit der Zinsanlage.
	 */
	public double getLaufzeit() {
		return zinsen.getLaufzeit();
	}

	/**
	 * Kopiert den Zinssatz aus der Eingabemaske in das Feld Zinssatz der Klasse
	 * Zinsen.
	 * 
	 * @param zinssatz.
	 */
	public void setZinssatz(double zinssatz) {
		zinsen.setZinssatz(zinssatz);
	}

	/**
	 * Liefert den Zinssatz aus der Klasse Zinsen.
	 * 
	 * @return zinssatz.
	 */
	public double getZinssatz() {
		return zinsen.getZinssatz();
	}

	/**
	 * Liefert die berechnete Summe aus der Klasse Zinsen.
	 * Formatiert die Summe in einen gueltigen Eurowert.
	 * 
	 * @return summe.
	 */
	public String getSumme() {
		double summe = zinsen.getSumme();
		BigDecimal bdSumme = new BigDecimal(0);
		bdSumme = BigDecimal.valueOf(summe);
		bdSumme = bdSumme.setScale(2, BigDecimal.ROUND_HALF_UP);

		return bdSumme + " Euro";
	}

	/**
	 * Wird beim Druecken des Reset-Buttons aufgerufen.
	 * Legt das Zinsobjekt neu an.
	 */
	public void reset(ActionMapping aMapping, HttpServletRequest aRequest) {
		this.zinsen = new Zinsen();		
	}

	/**
	 * Diese Methode wird beim Druecken des Berechnen-Buttons gestartet.
	 * Sie ueberprueft die Benutzereingaben auf der Maske.
	 * Wenn ein Wert 0 ist, wird eine Fehlermeldung ausgegeben und die Anwendung geht zur Eingabemaske zurueck.
	 */
	public ActionErrors validate(ActionMapping aMapping, HttpServletRequest aRequest) {
		ActionErrors theErrors = new ActionErrors();
		if ((zinsen.getBetrag() == 0)) {
			theErrors.add("Betrag", new ActionMessage("error.zinsen.betrag"));
		}
		if ((zinsen.getLaufzeit() == 0)) {
			theErrors.add("Laufzeit", new ActionMessage("error.zinsen.laufzeit"));
		}
		if ((zinsen.getZinssatz() == 0)) {
			theErrors.add("Zinssatz", new ActionMessage("error.zinsen.zinssatz"));
		}
		return theErrors;
	}
}
