package onlinerechner;

/**
 * Diese Bean-Klasse enthlt alle wichtigen Werte fuer die Zinsberechnung 
 * und fuehrt die Zinseszins-Berechnung durch
 * 
 * @author martin
 *
 */
public class Zinsen {
    
	// Eingabewerte
    private double betrag = 0;
    private double zinssatz = 0;
    private double laufzeit = 0;
    
    // Berechnetes Ergebnis
    private double summe = 0;
	 
    /**
     * Leerer Konstruktor, wird fuer Struts benoetigt.
     */
    public Zinsen() {    
    }

	/**
     * @return Liefert den Einzahlungs-Betrag.
     */
    public double getBetrag() {
        return betrag;
    }

    /**
     * @param Einzahlungs-Betrag setzen.
     */
    public void setBetrag(double betrag) {
        this.betrag = betrag;
    }

    /**
     * @return Liefert die Laufzeit der Zinsberechnung.
     */
    public double getLaufzeit() {
        return laufzeit;
    }

    /**
     * @param Setzt die Laufzeit der Zinsberechnung.
     */
    public void setLaufzeit(double laufzeit) {
        this.laufzeit = laufzeit;
    }

    /**
     * @return Liefert den Zinssatz.
     */
    public double getZinssatz() {
        return zinssatz;
    }

    /**
     * @param Setzt den Zinssatz.
     */
    public void setZinssatz(double zinssatz) {
        this.zinssatz = zinssatz;
    }
    
    /**
     * Berechnet die Zinsen aufgrund der Eingaben.
     * @return Liefert die Summe aus Zinsen und Einzahlung.
     */
    public double berechneZinsen() {
        summe = betrag;
         
        // Berechnet fuer jedes Jahr die Zinsen und Zinseszinsen
        for (int i = 1; i <= laufzeit; i++) {
            summe = summe + summe * (zinssatz / 100) ;
        }                        
        return summe;
    }
    
    /**
     * @return Liefert die Summe aus Zinsen und Einzahlung.
     */
    public double getSumme() {
        return berechneZinsen();
    }

}
