package onlinerechner;

import patterntesting.runtime.annotation.ProfileMe;

/**
 * Berechnet aus den Eingaben eine Hypothek
 * @author iusft
 */
@ProfileMe
public class HypoZinsen {
    
    private double betrag = 0;
    private double zinssatz = 0;
    private double tilgungssatz = 0;
    private double laufzeit = 0;
    
    private double restbetrag = 0;
    private double monatsRate = 0;
    
    public HypoZinsen() {
       
    }

    /**
     * @return Returns the betrag.
     */
    public double getBetrag() {
        return betrag;
    }

    /**
     * @param betrag The betrag to set.
     */
    public void setBetrag(double betrag) {
        this.betrag = betrag;
    }

    /**
     * @return Returns the laufzeit.
     */
    public double getLaufzeit() {
        return laufzeit;
    }

    /**
     * @param laufzeit The laufzeit to set.
     */
    public void setLaufzeit(double laufzeit) {
        this.laufzeit = laufzeit;
    }

    /**
     * @return Returns the zinssatz.
     */
    public double getZinssatz() {
        return zinssatz;
    }

    /**
     * @param zinssatz The zinssatz to set.
     */
    public void setZinssatz(double zinssatz) {
        this.zinssatz = zinssatz;
    }
    
    /**
     * @return Returns the restbetrag.
     */
    public double getRestbetrag() {
    	restbetrag = berechneRestbetrag();
        return restbetrag;
    }

    
    public double getMonatsRate() {
    	monatsRate = berechneMonatsrate();
		return monatsRate;
	}

	/**
     * @return Returns the tilgungssatz.
     */
    public double getTilgungssatz() {
        return tilgungssatz;
    }

    /**
     * @param tilgungssatz The tilgungssatz to set.
     */
    public void setTilgungssatz(double tilgungssatz) {
        this.tilgungssatz = tilgungssatz;
    }

    public double berechneRestbetrag() {
        restbetrag = betrag;
        double tilgungsBetrag = 0;
         
        for (int i = 1; i <= laufzeit; i++) {
            tilgungsBetrag = (tilgungssatz + zinssatz)  / 100 * betrag - (zinssatz)  / 100 * restbetrag;
            restbetrag = restbetrag - tilgungsBetrag;
        } 
        
        if (restbetrag > 100000) {
			System.out.println("Vorsicht, das wird eng! ");
		} else {
			System.out.println("Alles okay! ");
		}
        
        return restbetrag;
    }

	public double berechneMonatsrate() {
		monatsRate = betrag * (tilgungssatz + zinssatz)  / 100 / 12;
		return monatsRate;
	}

}
