package onlinerechner;

import java.math.BigDecimal;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class AutoRechnerForm extends ActionForm {

	private static final long serialVersionUID = 1L;
	
	private AutoKosten autoKosten = new AutoKosten();
	
	public void setKaufpreis(double kaufpreis) {
		autoKosten.setKaufpreis(kaufpreis);
	}

	public double getKaufpreis() {
		return autoKosten.getKaufpreis();
	}
	
	public void setWertverlustInProzent(double wertverlustInProzent) {
		autoKosten.setWertverlustInProzent(wertverlustInProzent);
	}

	public double getWertverlustInProzent() {
		return autoKosten.getWertverlustInProzent();
	}
	
	public void setSpritverbrauchAuf100km(double spritverbrauchAuf100km) {
		autoKosten.setSpritverbrauchAuf100km(spritverbrauchAuf100km);
	}

	public double getSpritverbrauchAuf100km() {
		return autoKosten.getSpritverbrauchAuf100km();
	}

	public void setSpritpreisProLiter(double spritpreisProLiter) {
		autoKosten.setSpritpreisProLiter(spritpreisProLiter);
	}

	public double getSpritpreisProLiter() {
		return autoKosten.getSpritpreisProLiter();
	}

	public void setKfzSteuer(double kfzSteuer) {
		autoKosten.setKfzSteuer(kfzSteuer);
	}
	
	public double getKfzSteuer() {
		return autoKosten.getKfzSteuer();
	}

	public void setKmProJahr(double kmProJahr) {
		autoKosten.setKmProJahr(kmProJahr);
	}
	
	public double getKmProJahr() {
		return autoKosten.getKmProJahr();
	}
	
	public void setWartungskostenProJahr(double wartungskostenProJahr) {
		autoKosten.setWartungskostenProJahr(wartungskostenProJahr);
	}
	
	public double getWartungskostenProJahr() {
		return autoKosten.getWartungskostenProJahr();
	}
	
	public void setVersicherungProJahr(double versicherungProJahr) {
		autoKosten.setVersicherungProJahr(versicherungProJahr);
	}
	
	public double getVersicherungProJahr() {
		return autoKosten.getVersicherungProJahr();
	}
	
/**
 * Berechnete Werte
 * @return
 */
	public String getKostenProJahr() {
		double kostenProJahr = autoKosten.getKostenProJahr();
    	BigDecimal bdKostenProJahr = new BigDecimal(0);
    	bdKostenProJahr = BigDecimal.valueOf(kostenProJahr);
    	bdKostenProJahr = bdKostenProJahr.setScale(2, BigDecimal.ROUND_HALF_UP);		 		
        return bdKostenProJahr + " Euro";
	}
	
	public String getKostenProKm() {
		double kostenProKm =  autoKosten.getKostenProKm();
    	BigDecimal bdKostenProKm = new BigDecimal(0);
    	bdKostenProKm = BigDecimal.valueOf(kostenProKm);
    	bdKostenProKm = bdKostenProKm.setScale(2, BigDecimal.ROUND_HALF_UP);		 		
        return bdKostenProKm + " Euro";
	}

	public void setAutoKosten(AutoKosten autoKosten) {
		this.autoKosten = autoKosten;
	}

	public AutoKosten getAutoKosten() {
		return this.autoKosten;
	}

	public void reset(ActionMapping aMapping, HttpServletRequest aRequest) {
		this.autoKosten = new AutoKosten();
		this.autoKosten.setKfzSteuer(0);
		this.autoKosten.setKmProJahr(0);
		this.autoKosten.setSpritpreisProLiter(0);
		this.autoKosten.setSpritverbrauchAuf100km(0);
		this.autoKosten.setKaufpreis(0);
		this.autoKosten.setWartungskostenProJahr(0);
		this.autoKosten.setWertverlustInProzent(0);
		this.autoKosten.setVersicherungProJahr(0);
	}

	public ActionErrors validate( ActionMapping aMapping,
			HttpServletRequest aRequest) {
		
		ActionErrors theErrors = new ActionErrors();
		 if ((autoKosten.getSpritverbrauchAuf100km() == 0) ) {
		 theErrors.add("Spritverbrauch", new ActionMessage("error.auto.spritverbrauchAuf100km"));
		 }
		        
		 if ((autoKosten.getKmProJahr() == 0) ) {
		 theErrors.add("Km pro Jahr", new
		 ActionMessage("error.auto.kmProJahr"));
		 }
		
		return theErrors;
	}

}
