package onlinerechner;

/**
 * Diese Klasse repraesentiert die Autokosten
 * @author iusft
 *
 */
public class AutoKosten {
	
	// Eingabewerte
	private double spritverbrauchAuf100km = 0;
	private double spritpreisProLiter = 0;
	private double kfzSteuer = 0;
	private double kmProJahr = 0;
	private double kaufpreis = 0;
	private double wertverlustInProzent = 0;
	private double wartungskostenProJahr = 0;
	private double versicherungProJahr = 0;
	
	// Berechnete Werte
	private double kostenProJahr = 0;
	private double kostenProKm = 0;

	public AutoKosten() {

	}

	public double getKaufpreis() {
		return kaufpreis;
	}


	public void setKaufpreis(double kaufpreis) {
		this.kaufpreis = kaufpreis;
	}


	public double getKostenProKm() {
		kostenProKm = berechneKostenProKm();
		return kostenProKm;
	}


	public void setKostenProKm(double kostenProKm) {
		this.kostenProKm = kostenProKm;
	}


	public double getWartungskostenProJahr() {
		return wartungskostenProJahr;
	}


	public void setWartungskostenProJahr(double wartungskostenProJahr) {
		this.wartungskostenProJahr = wartungskostenProJahr;
	}


	public double getWertverlustInProzent() {
		return wertverlustInProzent;
	}


	public void setWertverlustInProzent(double wertverlustInProzent) {
		this.wertverlustInProzent = wertverlustInProzent;
	}


	public double getKfzSteuer() {
		return kfzSteuer;
	}

	public void setKfzSteuer(double kfzSteuer) {
		this.kfzSteuer = kfzSteuer;
	}

	public double getSpritpreisProLiter() {
		return spritpreisProLiter;
	}

	public void setSpritpreisProLiter(double spritpreisProLiter) {
		this.spritpreisProLiter = spritpreisProLiter;
	}

	public double getSpritverbrauchAuf100km() {
		return spritverbrauchAuf100km;
	}

	public void setSpritverbrauchAuf100km(double spritverbrauchAuf100km) {
		this.spritverbrauchAuf100km = spritverbrauchAuf100km;
	}

	public void setKostenProJahr(double kostenProJahr) {
		this.kostenProJahr = kostenProJahr;
	}

	public double berechneKostenProJahr() {
		kostenProJahr = kmProJahr * spritpreisProLiter / 100 * spritverbrauchAuf100km / 100 + kfzSteuer + kaufpreis * 0.04 
		+ kaufpreis * wertverlustInProzent / 100 + wartungskostenProJahr + versicherungProJahr;
		return kostenProJahr;
	}
	
	public double berechneKostenProKm() {
		if (kmProJahr == 0) {
			return 0;
		}
		kostenProKm = berechneKostenProJahr() / kmProJahr;
		return kostenProKm;
	}

	/**
	 * @return Returns the summe.
	 */
	public double getKostenProJahr() {
		kostenProJahr = berechneKostenProJahr();
		return kostenProJahr;
	}

	public double getKmProJahr() {
		return kmProJahr;
	}

	public void setKmProJahr(double kmProJahr) {
		this.kmProJahr = kmProJahr;
	}

	public double getVersicherungProJahr() {
		return versicherungProJahr;
	}

	public void setVersicherungProJahr(double versicherungProJahr) {
		this.versicherungProJahr = versicherungProJahr;
	}

}
