package onlinerechner;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * Diese Klasse verabeitet die Benutzereingabe aus der Maske.
 * Danach leitet Sie den Anwender auf die Ergebnismaske weiter.
 * 
 * @author iusft
 */
public final class ZinsAction extends Action {  
    
    public ZinsAction() {                 
    }
    
    /**
     * Diese Methode wird aufgerufen, wenn der Benutzer den Berechnen-Button betaetigt hat und die Validierung erfolgreich war.
     */
    public ActionForward execute(ActionMapping aMapping, ActionForm aForm,
                                 HttpServletRequest aRequest, HttpServletResponse aResponse) {
               
    	/**
    	 * Eingabewerte aus der Maske ermitteln und in double-Werte umwandeln.
    	 */
        double betrag = Double.parseDouble(aRequest.getParameter("betrag"));
        double laufzeit = Double.parseDouble(aRequest.getParameter("laufzeit"));
        double zinssatz = Double.parseDouble(aRequest.getParameter("zinssatz"));
        
        /**
         * Eingabewerte dem Zinsobjekt zuweisen fuer die Berechnung.
         */
        Zinsen zinsen = new Zinsen();
        zinsen.setBetrag(betrag);
        zinsen.setLaufzeit(laufzeit);
        zinsen.setZinssatz(zinssatz);
                
        /**
         * Den Anwender auf die Ergebnisseite weiterleiten.
         */
        return aMapping.findForward("zinsenErgebnis");
    }
}
