package onlinerechner;

import java.math.BigDecimal;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

/**
 * Wertet die JSP hyporechner aus
 * @author iusft
 *
 */
public class HypoForm extends ActionForm {

    /**
	 * Eindeutige Nr zum serialisieren
	 */
	private static final long serialVersionUID = 1L;
	
	private HypoZinsen hypoZinsen = new HypoZinsen();   
    
    public void setBetrag(double betrag) {
        hypoZinsen.setBetrag(betrag);
    }
    
    public double getBetrag() {
        return hypoZinsen.getBetrag();
    }
    
    /**
     * @return Returns the laufzeit.
     */
    public double getLaufzeit() {
        return hypoZinsen.getLaufzeit();
    }

    /**
     * @param laufzeit The laufzeit to set.
     */
    public void setLaufzeit(double laufzeit) {
        hypoZinsen.setLaufzeit(laufzeit);
    }

    /**
     * @return Returns the zinssatz.
     */
    public double getZinssatz() {
        return hypoZinsen.getZinssatz();
    }
    
    /**
     * @param zinssatz The zinssatz to set.
     */
    public void setZinssatz(double zinssatz) {
        hypoZinsen.setZinssatz(zinssatz);
    }
    
    /**
     * @return Returns the zinssatz.
     */
    public double getTilgungssatz() {
        return hypoZinsen.getTilgungssatz();
    }
    
    /**
     * @return Returns the summe.
     */
    public String getRestbetrag() {
    	double restbetrag = hypoZinsen.getRestbetrag();
    	BigDecimal bdRestbetrag = new BigDecimal(0);
    	bdRestbetrag = BigDecimal.valueOf(restbetrag);
    	bdRestbetrag = bdRestbetrag.setScale(2, BigDecimal.ROUND_HALF_UP);
		 		
        return bdRestbetrag + " Euro";
    }
    
    /**
     * @return Returns the summe.
     */
    public String getMonatsRate() {
    	double monatsrate = hypoZinsen.getMonatsRate();
    	BigDecimal bdMonatsRate = new BigDecimal(0);
    	bdMonatsRate = BigDecimal.valueOf(monatsrate);
    	bdMonatsRate = bdMonatsRate.setScale(2, BigDecimal.ROUND_HALF_UP);
		 		
        return bdMonatsRate + " Euro";        
    }

    /**
     * @param zinssatz The zinssatz to set.
     */
    public void setTilgungssatz(double tilgungssatz) {
        hypoZinsen.setTilgungssatz(tilgungssatz);
    }
    
    public void setZinsen(HypoZinsen hypoZinsen) {
        this.hypoZinsen = hypoZinsen;
    }
    
    public HypoZinsen getHypoZinsen() {
        return this.hypoZinsen;
    }
    
    public void reset(ActionMapping aMapping, HttpServletRequest aRequest) {
        this.hypoZinsen = new HypoZinsen();
        this.hypoZinsen.setBetrag(0);
        
    }
    
    public ActionErrors validate(ActionMapping aMapping, HttpServletRequest aRequest) {
        ActionErrors theErrors = new ActionErrors();
        if ((hypoZinsen.getBetrag() == 0) ) {
            theErrors.add("Betrag", new ActionMessage("error.hypo.betrag"));
        }
        
        if ((hypoZinsen.getLaufzeit() == 0) ) {
            theErrors.add("Laufzeit", new ActionMessage("error.hypo.laufzeit"));
        }
        
        if ((hypoZinsen.getZinssatz() == 0) ) {
            theErrors.add("Zinssatz", new ActionMessage("error.hypo.zinssatz"));
        }
                
        return theErrors;
    }
    
}
