/**
 * martin
 *
 */
package gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;

import javax.swing.*;

import onlinerechner.*;

/**
 * Enthaelt alle GUI-Elemente der Finanzanwendung und steuert den GUI-Ablauf
 * 
 * @author iusft
 */
public class Hauptframe extends JFrame {

	private static final long serialVersionUID = 1L;

	/**
	 * Enthaelt alle GUI-Elemente.
	 */
	Hauptframe hauptframe;

	/**
	 * Panel, das die Buttons fuer das Starten der einzelnen Anwendungen enthaelt.
	 */
	JPanel hauptPanel;
	JButton zinsButton;
	JButton hypoButton;
	JButton autoButton;

	/**
	 * Zinspanel enthaelt alle Felder und Buttons fuer die Eingabe der Zinswerte 
	 */
	JPanel zinsPanel;
	JLabel zinsBetraglbl;
	JLabel zinssatzLbl;
	JLabel zinsLaufzeitLbl;
	
	JTextField zinsBetragtxt;
	JTextField zinssatzTxt;
	JTextField zinsLaufzeittxt;
	
	JButton berechneZinsBtn;

	/**
	 * Zinsergebnispanel enthaelt alle Felder fuer die Anzeige der Zinsberechnungsergebnisse 
	 */
	JPanel zinsErgebnisPnl;
	
	JLabel zinsUeberschriftlbl;
	JLabel zinsSummelbl;

	/**
	 * Hypopanel enthaelt alle Felder und Buttons fuer die Eingabe der Hypowerte 
	 */
	JPanel hypoPanel;
	JLabel hypoBetraglbl;
	JLabel hypoZinssatzLbl;
	JLabel hypoTilgSatzLbl;
	JLabel hypoLaufzeitLbl;

	JTextField hypoBetragtxt;
	JTextField hypoZinssatzTxt;
	JTextField hypoTilgSatzTxt;
	JTextField hypoLaufzeittxt;

	JButton berechneHypoBtn;
	
	/**
	 * Hypoergebnispanel enthaelt alle Felder fuer die Anzeige der Hypoberechnungsergebnisse 
	 */
	JPanel hypoErgebnisPnl;
	
	JLabel hypoUeberschriftlbl;
	JLabel hypoMonatsRatelbl;
	JLabel hypoRestbetraglbl;

	/**
	 * Autopanel enthaelt alle Felder und Buttons fuer die Eingabe der Autokosten 
	 */
	JPanel autoPanel;

	JLabel autoKaufpreislbl;
	JLabel autoSpritverbrauchAuf100kmLbl;
	JLabel autoSpritpreisProLiterLbl;
	JLabel autoKfzSteuerLbl;
	JLabel autoKmProJahrLbl;
	JLabel autoWertverlustInProzentLbl;
	JLabel autoWartungskostenProJahrLbl;
	JLabel autoVersicherungProJahrLbl;

	JTextField autoKaufpreisTxt;
	JTextField autoSpritverbrauchAuf100kmTxt;
	JTextField autoSpritpreisProLiterTxt;
	JTextField autoKfzSteuerTxt;
	JTextField autoKmProJahrTxt;
	JTextField autoWertverlustInProzentTxt;
	JTextField autoWartungskostenProJahrTxt;
	JTextField autoVersicherungProJahrTxt;

	JButton berechneautoBtn;

	/**
	 * Autoergebnispanel enthaelt alle Felder fuer die Anzeige der Autoberechnungsergebnisse 
	 */
	JPanel autoErgebnisPnl;
	
	JLabel autoUeberschriftlbl;
	JLabel autoKostenProKmlbl;
	JLabel autoKostenProJahrlbl;

	/**
	 * Im Konstruktor werden alle GUI-Elemente im HauptPanel aufgebaut.
	 *
	 */
	public Hauptframe() {
		hauptframe = this;
		
		hauptPanel = new JPanel();
		hauptPanel.setLayout(new BoxLayout(hauptPanel, BoxLayout.Y_AXIS));
		zinsButton = new JButton("Zinsrechner");
		zinsButton.addActionListener(new ZinsButtonListener());

		hypoButton = new JButton("Hypothekenrechner");
		hypoButton.addActionListener(new HypoButtonListener());

		autoButton = new JButton("Autokosten-Rechner");
		autoButton.addActionListener(new AutoButtonListener());

		hauptPanel.add(zinsButton);
		hauptPanel.add(hypoButton);
		hauptPanel.add(autoButton);
		hauptPanel.setBorder(BorderFactory.createLineBorder(Color.BLUE));

		/**
		 * Frame anzeigen
		 */
		hauptframe.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		hauptframe.getContentPane().add(BorderLayout.WEST, hauptPanel);
		hauptframe.setSize(600, 300);
		hauptframe.setLocation(300, 100);
		hauptframe.setVisible(true);
	}

	/**
	 * Listener fuer den Autokosten-Rechner-Button	
	 */
	class AutoButtonListener implements ActionListener {

		/** 
		 * Wird aufgerufen, wenn der Autokosten-Berechnen-Button gedrueckt wird.
		 */
		public void actionPerformed(ActionEvent e) {
			/**
			 * Offene Panels aus vorherigen Berechnungen entfernen.
			 */
			removePanels();

			/**
			 * Alle Labelwerte setzen
			 */
			autoKaufpreislbl = new JLabel("Kaufpreis:");
			autoSpritverbrauchAuf100kmLbl = new JLabel("Verbrauch:");
			autoSpritpreisProLiterLbl = new JLabel("Spritpreis:");
			autoKfzSteuerLbl = new JLabel("KfzSteuer:");
			autoKmProJahrLbl = new JLabel("Km / Jahr:");
			autoWertverlustInProzentLbl = new JLabel("Wertverlust in %:");
			autoWartungskostenProJahrLbl = new JLabel("Wartungskosten:");
			autoVersicherungProJahrLbl = new JLabel("Versicherungskosten:");

			/**
			 * Alle Eingabewerte vorbelegen
			 */
			autoKaufpreisTxt = new JTextField("0.00");
			autoSpritverbrauchAuf100kmTxt = new JTextField("0.00");
			autoSpritpreisProLiterTxt = new JTextField("0.00");
			autoKfzSteuerTxt = new JTextField("0.00");
			autoKmProJahrTxt = new JTextField("0.00");
			autoWertverlustInProzentTxt = new JTextField("0.00");
			autoWartungskostenProJahrTxt = new JTextField("0.00");
			autoVersicherungProJahrTxt = new JTextField("0.00");

			/**
			 * Button fuer das Berechnen der Autkosten anlegen.
			 * Einen ActionListener zuweisen.
			 */
			berechneautoBtn = new JButton("Berechne");
			berechneautoBtn.addActionListener(new BerechneAutoButtonListener());

			/**
			 * Autopanel mit den gesetzten Initialwerten anlegen
			 */
			autoPanel = new JPanel();

			autoPanel.setLayout(new GridLayout(9, 2));
			autoPanel.add(autoKaufpreislbl);
			autoPanel.add(autoKaufpreisTxt);

			autoPanel.add(autoSpritverbrauchAuf100kmLbl);
			autoPanel.add(autoSpritverbrauchAuf100kmTxt);

			autoPanel.add(autoSpritpreisProLiterLbl);
			autoPanel.add(autoSpritpreisProLiterTxt);

			autoPanel.add(autoKfzSteuerLbl);
			autoPanel.add(autoKfzSteuerTxt);

			autoPanel.add(autoKmProJahrLbl);
			autoPanel.add(autoKmProJahrTxt);

			autoPanel.add(autoWertverlustInProzentLbl);
			autoPanel.add(autoWertverlustInProzentTxt);

			autoPanel.add(autoWartungskostenProJahrLbl);
			autoPanel.add(autoWartungskostenProJahrTxt);
			
			autoPanel.add(autoVersicherungProJahrLbl);
			autoPanel.add(autoVersicherungProJahrTxt);

			autoPanel.add(new JLabel(""));
			autoPanel.add(berechneautoBtn);

			autoPanel.setBorder(BorderFactory.createLineBorder(Color.RED));

			/**
			 * Ergebnispanel fuer die Autokosten anlegen.
			 * Ueberschrift hinzufuegen.
			 */
			autoUeberschriftlbl = new JLabel("Ergebnis");
			autoErgebnisPnl = new JPanel();

			autoErgebnisPnl.setLayout(new BorderLayout());
			autoErgebnisPnl.add(BorderLayout.NORTH, autoUeberschriftlbl);
			autoErgebnisPnl.setBorder(BorderFactory.createLineBorder(Color.GREEN));

			/**
			 * Beide Autopanels dem Haupframe hinzufuegen und sichtbar machen.
			 */
			hauptframe.getContentPane().add(BorderLayout.CENTER, autoPanel);
			hauptframe.getContentPane().add(BorderLayout.EAST, autoErgebnisPnl);
			hauptframe.setVisible(true);
		}
	}

	/**
	 * Innere Klasse, die die Berechnung der Autokosten steuert.
	 */
	class BerechneAutoButtonListener implements ActionListener {

		/**
		 * Wird aufgerufen, wenn der Button, Berechne Autokosten, gedrueckt wird.
		 */
		public void actionPerformed(ActionEvent e) {
			if (autoKostenProJahrlbl == null) {
				autoKostenProJahrlbl = new JLabel("Kosten pro Jahr: ");
			}
			if (autoKostenProKmlbl == null) {
				autoKostenProKmlbl = new JLabel("Kosten pro KM: ");
			}

			/**
			 * Eingabewerte aus der Maske lesen und in double-Werte umrechnen.
			 */
			double kaufpreis = Double.valueOf(autoKaufpreisTxt.getText());
			double spritverbrauchAuf100km = Double.valueOf(autoSpritverbrauchAuf100kmTxt.getText());
			double spritpreisProLiter = Double.valueOf(autoSpritpreisProLiterTxt.getText());
			double kfzSteuer = Double.valueOf(autoKfzSteuerTxt.getText());
			double kmProJahr = Double.valueOf(autoKmProJahrTxt.getText());
			double wertverlustInProzent = Double.valueOf(autoWertverlustInProzentTxt.getText());
			double wartungskostenProJahr = Double.valueOf(autoWartungskostenProJahrTxt.getText());
			double versicherungProJahr = Double.valueOf(autoVersicherungProJahrTxt.getText());

			/**
			 * Berechnete Werte initialisieren.
			 */
			double kostenProJahr = 0;
			double kostenProKm = 0;
			
			BigDecimal bdKostenProJahr = new BigDecimal(0);
			BigDecimal bdKostenProKm = new BigDecimal(0);			

			/**
			 * Eingabewerte den Feldern in Autokosten zuweisen
			 */
			AutoKosten autoKosten = new AutoKosten();
			autoKosten.setKaufpreis(kaufpreis);
			autoKosten.setSpritverbrauchAuf100km(spritverbrauchAuf100km);
			autoKosten.setSpritpreisProLiter(spritpreisProLiter);
			autoKosten.setKfzSteuer(kfzSteuer);
			autoKosten.setKmProJahr(kmProJahr);
			autoKosten.setWertverlustInProzent(wertverlustInProzent);
			autoKosten.setWartungskostenProJahr(wartungskostenProJahr);
			autoKosten.setVersicherungProJahr(versicherungProJahr);
			
			/**
			 * Autokosten berechnen.
			 */
			kostenProJahr = autoKosten.berechneKostenProJahr();
			kostenProKm = autoKosten.berechneKostenProKm();

			/**
			 * Ergebnisse in Euro-Zahlen formatieren.
			 */
			bdKostenProJahr = BigDecimal.valueOf(kostenProJahr);
			bdKostenProJahr = bdKostenProJahr.setScale(2, BigDecimal.ROUND_HALF_UP);
			
			bdKostenProKm = BigDecimal.valueOf(kostenProKm);
			bdKostenProKm = bdKostenProKm.setScale(2, BigDecimal.ROUND_HALF_UP);
			
			/**
			 * Ergebnisse auf der Maske anzeigen.
			 */
			autoKostenProJahrlbl.setText("Kosten im Jahr: " + bdKostenProJahr + " Euro");
			autoKostenProKmlbl.setText("Kosten pro KM: " + bdKostenProKm + " Euro");

			autoErgebnisPnl.add(BorderLayout.CENTER, autoKostenProKmlbl);
			autoErgebnisPnl.add(BorderLayout.SOUTH, autoKostenProJahrlbl);

			hauptframe.setVisible(true);
		}
	}

	/**
	 * Listener fr den Button HypoRechner
	 */
	class HypoButtonListener implements ActionListener {

		/**
		 * wird aufgerufen, wenn der Button Hyporechner gedrueckt wird
		 */
		public void actionPerformed(ActionEvent e) {
			
			/**
			 * Offene Panels aus vorherigen Berechnungen entfernen.
			 */
			removePanels();

			/**
			 * Label setzen und Eingabewerte vorbelegen 
			 */
			hypoBetraglbl = new JLabel("Betrag:");
			hypoZinssatzLbl = new JLabel("Zinssatz:");
			hypoTilgSatzLbl = new JLabel("Tilgungssatz:");
			hypoLaufzeitLbl = new JLabel("Laufzeit:");

			hypoBetragtxt = new JTextField("0.00");
			hypoZinssatzTxt = new JTextField("0.00");
			hypoTilgSatzTxt = new JTextField("0.00");
			hypoLaufzeittxt = new JTextField("0.00");

			/**
			 * Button zum Berechnen der Hypothekenwerte
			 */
			berechneHypoBtn = new JButton("Berechne");
			berechneHypoBtn.addActionListener(new BerechneHypoButtonListener());

			/**
			 * Alle Label und Texte und den Button dem HypoPanel hinzufuegen. 
			 */
			hypoPanel = new JPanel();

			hypoPanel.setLayout(new GridLayout(5, 2));
			hypoPanel.add(hypoBetraglbl);
			hypoPanel.add(hypoBetragtxt);

			hypoPanel.add(hypoZinssatzLbl);
			hypoPanel.add(hypoZinssatzTxt);

			hypoPanel.add(hypoTilgSatzLbl);
			hypoPanel.add(hypoTilgSatzTxt);

			hypoPanel.add(hypoLaufzeitLbl);
			hypoPanel.add(hypoLaufzeittxt);

			hypoPanel.add(new JLabel(""));
			hypoPanel.add(berechneHypoBtn);

			hypoPanel.setBorder(BorderFactory.createLineBorder(Color.RED));

			/**
			 * Ergebnispanel der Hypo-Berechnung anlegen.
			 */
			hypoUeberschriftlbl = new JLabel("Ergebnis");
			hypoErgebnisPnl = new JPanel();			
			hypoErgebnisPnl.setLayout(new BorderLayout());
			hypoErgebnisPnl.add(BorderLayout.NORTH, hypoUeberschriftlbl);
			hypoErgebnisPnl.setBorder(BorderFactory.createLineBorder(Color.GREEN));

			/**
			 * Beide Panels dem Hauptframe hinzufuegen.
			 */
			hauptframe.getContentPane().add(BorderLayout.CENTER, hypoPanel);
			hauptframe.getContentPane().add(BorderLayout.EAST, hypoErgebnisPnl);
			hauptframe.setVisible(true);
		}
	}

	/**
	 * Steuert die Berechnung der Hypothekenwerte.
	 */
	class BerechneHypoButtonListener implements ActionListener {

		/**
		 * Wird aufgerufen, wenn der Button zum Berechnen der Hypothek gedrueckt wird.
		 */
		public void actionPerformed(ActionEvent e) {
			/**
			 * Ueberschrift anlegen.
			 */
			if (hypoRestbetraglbl == null) {
				hypoRestbetraglbl = new JLabel("Summe: ");
			}
			if (hypoMonatsRatelbl == null) {
				hypoMonatsRatelbl = new JLabel("Monatsrate: ");
			}

			/**
			 * Werte aus der Eingabemaske lesen und in double-Werte umwandeln.
			 */
			double betrag = Double.valueOf(hypoBetragtxt.getText());
			double zinssatz = Double.valueOf(hypoZinssatzTxt.getText());
			double tilgungssatz = Double.valueOf(hypoTilgSatzTxt.getText());
			double laufzeit = Double.valueOf(hypoLaufzeittxt.getText());

			/**
			 * Ergebniswerte initialisieren
			 */
			double restbetrag = 0;
			double monatsrate = 0;
			BigDecimal bdRestbetrag = new BigDecimal(0);
			BigDecimal bdMonatsrate = new BigDecimal(0);

			/**
			 * Eingabewerte an die Bean geben, um das Ergebnis berechnen zu koennen.
			 */
			HypoZinsen hypoZinsen = new HypoZinsen();
			hypoZinsen.setBetrag(betrag);
			hypoZinsen.setLaufzeit(laufzeit);
			hypoZinsen.setZinssatz(zinssatz);
			hypoZinsen.setTilgungssatz(tilgungssatz);

			/**
			 * Hypo-Ergebnis berechnen und in Euro-Werte formatieren.
			 */
			restbetrag = hypoZinsen.berechneRestbetrag();
			monatsrate = hypoZinsen.berechneMonatsrate();
			
			bdRestbetrag = BigDecimal.valueOf(restbetrag);
			bdRestbetrag = bdRestbetrag.setScale(2, BigDecimal.ROUND_HALF_UP);
			
			bdMonatsrate = BigDecimal.valueOf(monatsrate);
			bdMonatsrate = bdMonatsrate.setScale(2, BigDecimal.ROUND_HALF_UP);
			
			/**
			 * Ergebniswerte in die Ausgabefelder kopieren.
			 */
			hypoRestbetraglbl.setText("Summe: " + bdRestbetrag + " Euro");
			hypoMonatsRatelbl.setText("Monatsrate: " + bdMonatsrate + " Euro");

			/**
			 * Ergebnisse dem Panel zuweisen und anzeigen.
			 */
			hypoErgebnisPnl.add(BorderLayout.CENTER, hypoMonatsRatelbl);
			hypoErgebnisPnl.add(BorderLayout.SOUTH, hypoRestbetraglbl);

			hauptframe.setVisible(true);
		}
	}

	/**
	 * Listener fuer den Button ZinsRechner.
	 */
	class ZinsButtonListener implements ActionListener {

		/**
		 * Wird aufgerufen, wenn der Button ZinsRechner gedrueckt wird.
		 */
		public void actionPerformed(ActionEvent e) {
			/**
			 * Entfernt bereits vorhandene Panels aus dem Frame.
			 */
			removePanels();
			
			/**
			 * Label setzen, Werte vorbelegen und Button anlegen.
			 */
			zinsBetraglbl = new JLabel("Betrag:");
			zinssatzLbl = new JLabel("Zinssatz:");
			zinsLaufzeitLbl = new JLabel("Laufzeit:");

			zinsBetragtxt = new JTextField("0.00");
			zinssatzTxt = new JTextField("0.00");
			zinsLaufzeittxt = new JTextField("0.00");

			berechneZinsBtn = new JButton("Berechne");
			berechneZinsBtn.addActionListener(new BerechneZinsButtonListener());

			/**
			 * Zinspanel anlegen und die Initialwerte mitgeben.
			 */
			zinsPanel = new JPanel();

			zinsPanel.setLayout(new GridLayout(4, 2));
			zinsPanel.add(zinsBetraglbl);
			zinsPanel.add(zinsBetragtxt);

			zinsPanel.add(zinssatzLbl);
			zinsPanel.add(zinssatzTxt);

			zinsPanel.add(zinsLaufzeitLbl);
			zinsPanel.add(zinsLaufzeittxt);

			zinsPanel.add(new JLabel(""));
			zinsPanel.add(berechneZinsBtn);

			zinsPanel.setBorder(BorderFactory.createLineBorder(Color.RED));

			/**
			 * ZinsErgebnisPanel anlegen und initial fuellen.
			 */
			zinsUeberschriftlbl = new JLabel("Ergebnis");
			zinsErgebnisPnl = new JPanel();			
			zinsErgebnisPnl.setLayout(new BorderLayout());
			zinsErgebnisPnl.add(BorderLayout.NORTH, zinsUeberschriftlbl);
			zinsErgebnisPnl.setBorder(BorderFactory.createLineBorder(Color.GREEN));

			hauptframe.getContentPane().add(BorderLayout.CENTER, zinsPanel);
			hauptframe.getContentPane().add(BorderLayout.EAST, zinsErgebnisPnl);
			hauptframe.setVisible(true);
		}
	}

	/**
	 * Steuert die Berechnung der Zinsen.
	 */
	class BerechneZinsButtonListener implements ActionListener {

		/**
		 * Wird aufgerufen, wenn der Button Berechne Zinsen gedrueckt wird.
		 */
		public void actionPerformed(ActionEvent e) {
			/**
			 * Label anlegen.
			 */
			if (zinsSummelbl == null) {
				zinsSummelbl = new JLabel("Summe: ");
			}

			/**
			 * Werte aus der Eingabe lesen und in double-Werte konvertieren
			 */
			double betrag = Double.valueOf(zinsBetragtxt.getText());
			double zinssatz = Double.valueOf(zinssatzTxt.getText());
			double laufzeit = Double.valueOf(zinsLaufzeittxt.getText());

			/**
			 * Ergebnis initialisieren und formatieren.
			 */
			double summe = 0;
			BigDecimal bdSumme = new BigDecimal(0);

			/**
			 * Eingabewerte fuer die folgende Berechnung an die Zinsen-Bean geben.
			 */
			Zinsen zinsen = new Zinsen();
			zinsen.setBetrag(betrag);
			zinsen.setLaufzeit(laufzeit);
			zinsen.setZinssatz(zinssatz);

			/**
			 * Ergebnis berechnen und formatieren in einen gueltigen Euro-Wert
			 */
			summe = zinsen.getSumme();
						
			bdSumme = BigDecimal.valueOf(summe);
			bdSumme = bdSumme.setScale(2, BigDecimal.ROUND_HALF_UP);

			/**
			 * Ergebnis dem Ausgabefeld zuweisen und anzeigen.
			 */
			zinsSummelbl.setText("Summe: " + bdSumme + " Euro");

			zinsErgebnisPnl.add(BorderLayout.SOUTH, zinsSummelbl);

			hauptframe.setVisible(true);
		}
	}

	/**
	 * Entfernt offene Panels aus vorherigen Berechnungen.
	 */
	void removePanels() {
		if (hypoPanel != null) {
			hauptframe.remove(hypoPanel);
		}
		if (hypoErgebnisPnl != null) {
			hauptframe.remove(hypoErgebnisPnl);
		}
		if (zinsPanel != null) {
			hauptframe.remove(zinsPanel);
		}
		if (zinsErgebnisPnl != null) {
			hauptframe.remove(zinsErgebnisPnl);
		}
		if (autoPanel != null) {
			hauptframe.remove(autoPanel);
		}
		if (autoErgebnisPnl != null) {
			hauptframe.remove(autoErgebnisPnl);
		}
	}
}
