/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import patterntesting.runtime.annotation.LogThrowable;
import patterntesting.runtime.log.LogThrowableAspect;
import patterntesting.runtime.monitor.AbstractProfileMonitor;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.util.SignatureHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleProfileMonitor
extends AbstractProfileMonitor {
    private static final Log log;
    private SimpleProfileMonitor parent;
    private Collection<SimpleProfileMonitor> childs;
    private final Signature label;
    private long startTime;
    private double total;
    private double lastValue;
    private double min;
    private double max;
    private int hits;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;

    static {
        Factory factory = new Factory("SimpleProfileMonitor.java", Class.forName("patterntesting.runtime.monitor.SimpleProfileMonitor"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", ""), 53);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "reset", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "void"), 58);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "add", "patterntesting.runtime.monitor.SimpleProfileMonitor", "double:", "value:", "", "void"), 144);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTotal", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "double"), 162);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLastValue", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "double"), 169);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMax", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "double"), 176);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMin", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "double"), 183);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getHits", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "int"), 190);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAvg", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "double"), 197);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLabel", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "java.lang.String"), 201);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "java.lang.String"), 210);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toShortString", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "java.lang.String"), 214);
        ajc$tjp_2 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "patterntesting.runtime.monitor.SimpleProfileMonitor", "org.aspectj.lang.Signature:patterntesting.runtime.monitor.SimpleProfileMonitor:", "label:parent:", ""), 68);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toCsvHeadline", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "java.lang.String"), 219);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toCsvString", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "java.lang.String"), 223);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUnits", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "java.lang.String"), 229);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActive", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "double"), 233);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAvgActive", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "double"), 237);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirstAccess", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "java.util.Date"), 241);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLastAccess", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "java.util.Date"), 245);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxActive", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "double"), 249);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "addChild", "patterntesting.runtime.monitor.SimpleProfileMonitor", "patterntesting.runtime.monitor.SimpleProfileMonitor:", "child:", "", "void"), 75);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addChildren", "patterntesting.runtime.monitor.SimpleProfileMonitor", "java.util.List:", "labels:", "", "void"), 79);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addChild", "patterntesting.runtime.monitor.SimpleProfileMonitor", "java.lang.String:", "label:", "", "void"), 85);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMonitors", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "[Lpatterntesting.runtime.monitor.ProfileMonitor;"), 98);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMonitor", "patterntesting.runtime.monitor.SimpleProfileMonitor", "org.aspectj.lang.Signature:", "sig:", "", "patterntesting.runtime.monitor.SimpleProfileMonitor"), 109);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "void"), 129);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "patterntesting.runtime.monitor.SimpleProfileMonitor", "", "", "", "void"), 136);
        log = LogFactoryImpl.getLog(SimpleProfileMonitor.class);
    }

    public SimpleProfileMonitor() {
        try {
            this.reset();
            this.label = null;
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public void reset() {
        try {
            this.total = 0.0;
            this.lastValue = 0.0;
            this.min = Double.MAX_VALUE;
            this.max = 0.0;
            this.hits = 0;
            this.parent = null;
            this.childs = new ConcurrentLinkedQueue<SimpleProfileMonitor>();
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    public SimpleProfileMonitor(Signature label, SimpleProfileMonitor parent) {
        Signature signature = label;
        SimpleProfileMonitor simpleProfileMonitor = parent;
        try {
            this.reset();
            this.label = label;
            this.parent = parent;
            this.parent.addChild(this);
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)signature, (Object)simpleProfileMonitor));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addChild(SimpleProfileMonitor simpleProfileMonitor) {
        SimpleProfileMonitor simpleProfileMonitor2 = simpleProfileMonitor;
        try {
            void child;
            this.childs.add((SimpleProfileMonitor)child);
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)simpleProfileMonitor2));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addChildren(List<String> list) {
        List<String> list2 = list;
        try {
            void labels;
            for (String label : labels) {
                this.addChild(label);
            }
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list2));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addChild(String string) {
        String string2 = string;
        try {
            void label;
            try {
                Signature sig = SignatureHelper.getAsSignature((String)label);
                SimpleProfileMonitor child = new SimpleProfileMonitor(sig, this);
                this.addChild(child);
            }
            catch (Exception e) {
                log.debug((Object)("can't add " + (String)label), (Throwable)e);
            }
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string2));
            }
            throw throwable;
        }
    }

    @Override
    public ProfileMonitor[] getMonitors() {
        try {
            return this.childs.toArray(new SimpleProfileMonitor[this.childs.size()]);
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SimpleProfileMonitor getMonitor(Signature signature) {
        Signature signature2 = signature;
        try {
            void sig;
            String label = SignatureHelper.getAsString((Signature)sig);
            for (SimpleProfileMonitor mon : this.childs) {
                String monLabel = SignatureHelper.getAsString(mon.label);
                if (!label.equals(monLabel)) continue;
                return mon;
            }
            return null;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)signature2));
            }
            throw throwable;
        }
    }

    @Override
    public void start() {
        try {
            this.startTime = System.nanoTime();
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public void stop() {
        try {
            long time = System.nanoTime() - this.startTime;
            this.add((double)time / 1000000.0);
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(double d) {
        double d2 = d;
        try {
            void value;
            this.lastValue = value;
            this.total += value;
            ++this.hits;
            if (this.parent != null) {
                this.parent.add((double)value);
            }
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d2)));
            }
            throw throwable;
        }
    }

    @Override
    public double getTotal() {
        try {
            return this.total;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public double getLastValue() {
        try {
            return this.lastValue;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public double getMax() {
        try {
            return this.max;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public double getMin() {
        try {
            return this.min;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public int getHits() {
        try {
            return this.hits;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public double getAvg() {
        try {
            return this.total / (double)this.hits;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String getLabel() {
        try {
            if (this.label == null) {
                return "root";
            }
            return SignatureHelper.getAsString(this.label);
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    public String toString() {
        try {
            return String.valueOf(this.getLabel()) + " - " + this.toShortString();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String toShortString() {
        try {
            return "total: " + this.total + " ms / avg: " + this.getAvg() + " ms / hits: " + this.hits;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String toCsvHeadline() {
        try {
            return "Label; Unit; Total; Avg; Hits; Max; Min";
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String toCsvString() {
        try {
            return String.valueOf(this.getLabel()) + "; ms; " + this.total + "; " + this.getAvg() + "; " + this.hits + "; " + this.getMax() + ";" + this.getMin();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String getUnits() {
        try {
            return "ms";
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public double getActive() {
        try {
            return 0.0;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public double getAvgActive() {
        try {
            return 0.0;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public Date getFirstAccess() {
        try {
            return null;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public Date getLastAccess() {
        try {
            return null;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public double getMaxActive() {
        try {
            return 0.0;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }
}

