/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import patterntesting.runtime.annotation.LogThrowable;
import patterntesting.runtime.log.LogThrowableAspect;
import patterntesting.runtime.util.Converter;

public class MemoryGuard {
    private static final Log log;
    private static final long maxMem;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        Factory factory = new Factory("MemoryGuard.java", Class.forName("patterntesting.runtime.monitor.MemoryGuard"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "patterntesting.runtime.monitor.MemoryGuard", "", "", ""), 32);
        log = LogFactoryImpl.getLog(MemoryGuard.class);
        maxMem = Runtime.getRuntime().maxMemory();
    }

    public MemoryGuard() {
        try {
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    public static long getFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        long totalMem = runtime.totalMemory();
        return runtime.freeMemory() + (maxMem - totalMem);
    }

    public static int getFreeMemoryInPercent() {
        long freeMem = MemoryGuard.getFreeMemory();
        int rate = (int)((freeMem + 50L) * 100L / maxMem);
        return rate;
    }

    public static String getFreeMemoryAsString() {
        return Converter.getMemoryAsString(MemoryGuard.getFreeMemory());
    }

    public static void logMemory() {
        MemoryGuard.logMemory(log);
    }

    public static void logMemory(Log log) {
        int freeMemRate = MemoryGuard.getFreeMemoryInPercent();
        if (freeMemRate < 10) {
            System.gc();
            if (log.isTraceEnabled()) {
                log.trace((Object)("gc() called because free memory is below 10% (" + freeMemRate + "%)"));
            }
            freeMemRate = MemoryGuard.getFreeMemoryInPercent();
        }
        if (freeMemRate < 1) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)MemoryGuard.getMemoryLogMessage(freeMemRate));
            }
        } else if (freeMemRate < 2) {
            if (log.isErrorEnabled()) {
                log.error((Object)MemoryGuard.getMemoryLogMessage(freeMemRate));
            }
        } else if (freeMemRate < 10) {
            if (log.isWarnEnabled()) {
                log.warn((Object)MemoryGuard.getMemoryLogMessage(freeMemRate));
            }
        } else if (freeMemRate < 20) {
            if (log.isInfoEnabled()) {
                log.info((Object)MemoryGuard.getMemoryLogMessage(freeMemRate));
            }
        } else if (freeMemRate < 50) {
            if (log.isDebugEnabled()) {
                log.debug((Object)MemoryGuard.getMemoryLogMessage(freeMemRate));
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)MemoryGuard.getMemoryLogMessage(freeMemRate));
        }
    }

    public static String getMemoryLogMessage() {
        int freeMemRate = MemoryGuard.getFreeMemoryInPercent();
        return MemoryGuard.getMemoryLogMessage(freeMemRate);
    }

    private static String getMemoryLogMessage(int freeMemRate) {
        return String.valueOf(freeMemRate) + "% of memory is free (" + MemoryGuard.getFreeMemoryAsString() + ")";
    }

    public static void logFreeMemory(final long interval) throws InterruptedException {
        Runnable work = new Runnable(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
            {
                long l2 = l;
                try {
                    return;
                }
                catch (Throwable throwable) {
                    if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                        LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2)));
                    }
                    throw throwable;
                }
            }

            /*
             * Unable to fully structure code
             */
            public void run() {
                try {
                    while (true) lbl-1000:
                    // 2 sources

                    {
                        MemoryGuard.logMemory();
                        try {
                            Thread.sleep(interval);
                            continue;
                        }
                        catch (InterruptedException e) {
                            MemoryGuard.access$0().debug((Object)(this + " interrupted"), (Throwable)e);
                            return;
                        }
                        break;
                    }
                }
                catch (Throwable var3_2) {
                    if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                        LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), var3_2, Factory.makeJP((JoinPoint.StaticPart)1.ajc$tjp_1, (Object)this, (Object)this));
                    }
                    throw var3_2;
                }
                {
                    ** while (true)
                }
            }

            static {
                Factory factory = new Factory("MemoryGuard.java", Class.forName("patterntesting.runtime.monitor.MemoryGuard$1"));
                ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("0", "patterntesting.runtime.monitor.MemoryGuard$1", "long:", "arg0:", ""), 127);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "patterntesting.runtime.monitor.MemoryGuard$1", "", "", "", "void"), 128);
            }
        };
        Thread t = new Thread(work, "background");
        t.start();
    }

    static /* synthetic */ Log access$0() {
        return log;
    }
}

