/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.xml.sax.SAXException;
import patterntesting.runtime.annotation.LogThrowable;
import patterntesting.runtime.log.LogThrowableAspect;

public class SAXHelper {
    private static final Log log;
    public static final String DRIVER_PROPERTY = "org.xml.sax.driver";
    public static final String DRIVER_RESOURCE = "META-INF/services/org.xml.sax.driver";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        Factory factory = new Factory("SAXHelper.java", Class.forName("patterntesting.runtime.xml.SAXHelper"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "patterntesting.runtime.xml.SAXHelper", "", "", ""), 35);
        log = LogFactoryImpl.getLog(SAXHelper.class);
    }

    public SAXHelper() {
        try {
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    public static SAXException betterSAXException(SAXException saxe) {
        String msg = saxe.getMessage();
        String className = SAXHelper.parseMessage(msg);
        if (className == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("unknown message '" + msg + "' - returning " + saxe + "..."));
            }
            return saxe;
        }
        if (SAXHelper.isDriverPropertySetWith(className)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("conflict with property org.xml.sax.driver=" + className + " detected"));
            }
            msg = String.valueOf(msg) + " - check property \"" + DRIVER_PROPERTY + "\"";
            return SAXHelper.betterSAXException(saxe, msg);
        }
        if (SAXHelper.isDriverResourceSetWith(className)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("conflict with resource META-INF/services/org.xml.sax.driver=" + className + " detected"));
            }
            msg = String.valueOf(msg) + " - check system resource \"" + DRIVER_RESOURCE + "\"";
            return SAXHelper.betterSAXException(saxe, msg);
        }
        return saxe;
    }

    public static SAXException betterSAXException(SAXException saxe, String newMessage) {
        Exception cause = saxe.getException();
        SAXException betterException = new SAXException(newMessage, cause);
        betterException.setStackTrace(saxe.getStackTrace());
        return betterException;
    }

    private static String parseMessage(String msg) {
        String prefix = "SAX2 driver class ";
        if (msg.startsWith(prefix)) {
            return StringUtils.substringBetween((String)msg, (String)prefix, (String)" ");
        }
        return null;
    }

    private static boolean isDriverPropertySetWith(String className) {
        String prop = System.getProperty(DRIVER_PROPERTY);
        return className.equals(prop);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isDriverResourceSetWith(String className) {
        InputStream in = ClassLoader.getSystemResourceAsStream(DRIVER_RESOURCE);
        if (in == null) {
            return false;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF8"));
            String driver = reader.readLine();
            if (StringUtils.isBlank((String)driver)) {
                log.warn((Object)"no classname found in META-INF/services/org.xml.sax.driver");
                return false;
            }
            boolean bl = driver.equals(className);
            return bl;
        }
        catch (IOException ioe) {
            log.warn((Object)("can't read META-INF/services/org.xml.sax.driver (" + ioe + ")"));
            return false;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

