/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.junit.Assert;
import org.junit.Test;
import patterntesting.runtime.annotation.ProfileMe;
import patterntesting.runtime.monitor.ProfileStatistic;
import patterntesting.runtime.util.ThreadUtil;

public class ProfileTest {
    private static final Log log = LogFactoryImpl.getLog(ProfileTest.class);
    private static final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    static /* synthetic */ Class class$0;

    @ProfileMe
    public ProfileTest() {
        log.debug((Object)(this + " created"));
    }

    @Test
    @ProfileMe
    public final void testProfiler() throws JMException {
        int calls = 2;
        int i = 0;
        while (i < calls) {
            this.callDummy();
            ++i;
        }
        Integer maxCalls = (Integer)mbeanServer.getAttribute(ProfileStatistic.mbeanName, "MaxHits");
        Assert.assertEquals((long)calls, (long)maxCalls.intValue());
    }

    @ProfileMe
    private final void callDummy() {
        ThreadUtil.sleep();
    }

    @Test
    public final void testRun() throws JMException, InterruptedException {
        mbeanServer.invoke(ProfileStatistic.mbeanName, "logStatistic", null, null);
    }
}

