/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.jmx;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import patterntesting.runtime.annotation.LogThrowable;
import patterntesting.runtime.log.LogThrowableAspect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanHelper {
    private static final Log log;
    private static MBeanServer server;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        Factory factory = new Factory("MBeanHelper.java", Class.forName("patterntesting.runtime.jmx.MBeanHelper"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "patterntesting.runtime.jmx.MBeanHelper", "", "", ""), 34);
        log = LogFactoryImpl.getLog(MBeanHelper.class);
        server = ManagementFactory.getPlatformMBeanServer();
    }

    public MBeanHelper() {
        try {
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    public static String getMBeanName(Object mbean) {
        return MBeanHelper.getMBeanName(mbean.getClass());
    }

    public static String getMBeanName(Class<?> cl) {
        return String.valueOf(cl.getPackage().getName()) + ":type=" + cl.getSimpleName();
    }

    public static void registerMBean(Object mbean) throws JMException {
        String mbeanName = MBeanHelper.getMBeanName(mbean);
        MBeanHelper.registerMBean(mbeanName, mbean);
    }

    public static synchronized void registerMBean(String mbeanName, Object mbean) {
        try {
            ObjectName name = new ObjectName(mbeanName);
            MBeanHelper.registerMBean(name, mbean);
        }
        catch (MalformedObjectNameException e) {
            log.info((Object)("can't register <" + mbean + "> as MBean"), (Throwable)e);
        }
    }

    public static synchronized void registerMBean(ObjectName name, Object mbean) {
        try {
            log.trace((Object)("registering " + name + "..."));
            server.registerMBean(mbean, name);
            log.debug((Object)(name + " successful registered as MBean"));
        }
        catch (Exception e) {
            log.info((Object)("can't register <" + mbean + "> as MBean"), (Throwable)e);
        }
    }

    public static synchronized void unregisterMBean(String mbeanName) {
        try {
            ObjectName name = new ObjectName(mbeanName);
            server.unregisterMBean(name);
            log.debug((Object)("MBean " + name + " successful unregistered"));
        }
        catch (Exception e) {
            log.info((Object)("can't unregister " + mbeanName), (Throwable)e);
        }
    }

    public static boolean isRegistered(String mbeanName) {
        try {
            ObjectName name = new ObjectName(mbeanName);
            ObjectInstance mbean = server.getObjectInstance(name);
            return mbean != null;
        }
        catch (Exception e) {
            log.trace((Object)(String.valueOf(mbeanName) + " not found (" + e + ")"));
            return false;
        }
    }

    public static boolean isRegistered(Object obj) {
        String mbeanName = MBeanHelper.getMBeanName(obj.getClass());
        return MBeanHelper.isRegistered(mbeanName);
    }
}

