/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.concurrent;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.junit.Assert;
import org.junit.Test;
import patterntesting.runtime.annotation.Synchronized;
import patterntesting.runtime.util.ThreadUtil;

@ThreadSafe
@Synchronized
public class SynchronizedStaticTest
implements Runnable {
    private static Log log = LogFactoryImpl.getLog(SynchronizedStaticTest.class);
    private static int counter = 1;
    static /* synthetic */ Class class$0;

    @Test
    public final void testMultiThreading() throws InterruptedException {
        SynchronizedStaticTest r = new SynchronizedStaticTest();
        Thread t1 = new Thread((Runnable)r, "t1");
        Thread t2 = new Thread((Runnable)r, "t2");
        int n = counter;
        log.info((Object)"starting t1 and t2...");
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        log.info((Object)"thread t1 and t2 has finished");
        Assert.assertEquals((String)"lost update", (long)(n + 2), (long)counter);
    }

    @GuardedBy(value="SynchronizedStaticAspect")
    @Synchronized
    public static void incrementCounter() {
        int n = counter;
        log.debug((Object)("counter read (" + n + ")"));
        ThreadUtil.sleep(20L);
        log.debug((Object)("counter increased (" + ++n + ")"));
        ThreadUtil.sleep(20L);
        counter = n;
        log.debug((Object)("counter written (" + n + ")"));
    }

    public void run() {
        SynchronizedStaticTest.incrementCounter();
    }
}

