/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import patterntesting.runtime.util.ThreadUtil;

public class ThreadUtilTest {
    private static final long minT = ThreadUtil.getTimerResolutionInMillis();

    @Test
    public void testCalibrate() {
        Assert.assertTrue((minT > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSleepLong() {
        long t = System.currentTimeMillis();
        ThreadUtil.sleep(minT);
        Assert.assertTrue((System.currentTimeMillis() - t >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSleepLongInt() {
        long t = System.currentTimeMillis();
        ThreadUtil.sleep(minT, 500);
        Assert.assertTrue((System.currentTimeMillis() - t >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSleepTimeUnit() {
        long t = System.currentTimeMillis();
        ThreadUtil.sleep((int)minT, TimeUnit.MILLISECONDS);
        Assert.assertTrue((System.currentTimeMillis() - t >= 0L ? 1 : 0) != 0);
    }
}

