/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import patterntesting.runtime.annotation.LogThrowable;
import patterntesting.runtime.log.LogThrowableAspect;

public class ThreadUtil {
    private static Log log;
    private static final long timeInMillis;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        Factory factory = new Factory("ThreadUtil.java", Class.forName("patterntesting.runtime.util.ThreadUtil"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "patterntesting.runtime.util.ThreadUtil", "", "", ""), 32);
        log = LogFactoryImpl.getLog(ThreadUtil.class);
        timeInMillis = ThreadUtil.calibrateMillis();
        log.debug((Object)("timeInMillis calibrated (" + timeInMillis + "ms)"));
    }

    public ThreadUtil() {
        try {
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    public static void sleep() {
        ThreadUtil.sleep(timeInMillis);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ignored) {
            log.info((Object)(ignored + " ignored"));
        }
    }

    public static void sleep(long millis, int nanos) {
        try {
            Thread.sleep(millis, nanos);
        }
        catch (InterruptedException ignored) {
            log.info((Object)(ignored + " ignored"));
        }
    }

    public static void sleep(int time, TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                ThreadUtil.sleep(0L, time);
                break;
            }
            case MICROSECONDS: {
                ThreadUtil.sleep(0L, time * 1000);
                break;
            }
            case MILLISECONDS: {
                ThreadUtil.sleep(time);
                break;
            }
            case SECONDS: {
                ThreadUtil.sleep((long)time * 1000L);
                break;
            }
            default: {
                log.warn((Object)("unknown TimeUnit " + (Object)((Object)unit) + " interpreting it as MINUTES"));
                ThreadUtil.sleep((long)time * 1000L * 60L);
            }
        }
    }

    private static long calibrateMillis() {
        long t0 = ThreadUtil.nextTimeMillis();
        long t1 = ThreadUtil.nextTimeMillis();
        return t1 - t0;
    }

    private static long nextTimeMillis() {
        long t0 = System.currentTimeMillis();
        while (t0 == System.currentTimeMillis()) {
        }
        return System.currentTimeMillis();
    }

    public static long getTimerResolutionInMillis() {
        return timeInMillis;
    }
}

