/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.AdviceSignature;
import org.aspectj.lang.reflect.CatchClauseSignature;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.ProfileStatistic;
import patterntesting.runtime.util.ThreadUtil;

public class ProfileStatisticTest {
    private static final Log log = LogFactoryImpl.getLog(ProfileStatisticTest.class);
    private static final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private static Signature[] signatures = new Signature[5];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    @BeforeClass
    public static void setUp() {
        ProfileStatisticTest.signatures[0] = (Signature)EasyMock.createMock(Signature.class);
        ProfileStatisticTest.signatures[1] = (Signature)EasyMock.createMock(AdviceSignature.class);
        ProfileStatisticTest.signatures[2] = (Signature)EasyMock.createMock(CatchClauseSignature.class);
        ProfileStatisticTest.signatures[3] = (Signature)EasyMock.createMock(CodeSignature.class);
        ProfileStatisticTest.signatures[4] = (Signature)EasyMock.createMock(ConstructorSignature.class);
    }

    @Test
    public final void testStart() {
        ProfileMonitor[] monitors = new ProfileMonitor[signatures.length];
        int i = 0;
        while (i < signatures.length) {
            monitors[i] = ProfileStatistic.start(signatures[i]);
            ++i;
        }
        i = 0;
        while (i < signatures.length) {
            monitors[i].stop();
            log.info((Object)("monitor[" + i + "] = " + monitors[i]));
            Assert.assertEquals((long)1L, (long)monitors[i].getHits());
            Assert.assertTrue((monitors[i].getLastValue() >= 0.0 ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public final void testMaxHits() {
        ProfileMonitor profMon = ProfileStatistic.start(signatures[0]);
        profMon.stop();
        Assert.assertTrue((ProfileStatistic.getInstance().getMaxHits() > 0 ? 1 : 0) != 0);
    }

    @Test
    public final void testMaxAvg() {
        ProfileMonitor profMon = ProfileStatistic.start(signatures[1]);
        ThreadUtil.sleep();
        profMon.stop();
        ProfileStatistic statistic = ProfileStatistic.getInstance();
        double maxAvg = statistic.getMaxAvg();
        log.info((Object)("maxAvg: " + maxAvg + " ms from " + statistic.getMaxAvgLabel()));
        Assert.assertTrue((maxAvg > 0.9 ? 1 : 0) != 0);
    }

    @Test
    public final void testMBeanRegistration() throws JMException {
        Integer hits = (Integer)mbeanServer.getAttribute(ProfileStatistic.mbeanName, "MaxHits");
        log.info((Object)("max hits: " + hits));
        Assert.assertTrue((hits >= 0 ? 1 : 0) != 0);
    }

    @Test
    public final void testLogStatistic() {
        ProfileStatistic.getInstance().logStatistic();
    }

    @Test
    public final void testDumpStatistic() {
        ProfileStatistic.getInstance().dumpStatistic();
    }

    @Test
    public final void testGetSortedMonitors() {
        ProfileMonitor[] monitors = ProfileStatistic.getSortedMonitors();
        Assert.assertTrue((monitors[0].getTotal() >= monitors[1].getTotal() ? 1 : 0) != 0);
    }

    @Test
    public final void testRegisterAsShutdownHook() {
        ProfileStatistic statistic = ProfileStatistic.getInstance();
        Runtime.getRuntime().addShutdownHook(statistic);
        log.info((Object)(statistic + " registered as shutdown hook"));
    }
}

