/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.runtime.reflect.Factory;
import patterntesting.annotation.check.runtime.MayReturnNull;
import patterntesting.runtime.annotation.DontProfileMe;
import patterntesting.runtime.annotation.LogThrowable;
import patterntesting.runtime.log.LogThrowableAspect;
import patterntesting.runtime.monitor.ClasspathMonitor;
import patterntesting.runtime.monitor.JamonMonitorFactory;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.ProfileStatisticMBean;
import patterntesting.runtime.monitor.SimpleProfileMonitor;
import patterntesting.runtime.util.SignatureHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileStatistic
extends Thread
implements ProfileStatisticMBean {
    public static final ObjectName mbeanName;
    private static final ProfileStatistic instance;
    private static final Log log;
    private static final SimpleProfileMonitor rootMonitor;
    private static final boolean jamonAvailable;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;

    static {
        Factory factory = new Factory("ProfileStatistic.java", Class.forName("patterntesting.runtime.monitor.ProfileStatistic"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("4", "patterntesting.runtime.monitor.ProfileStatistic", "", "", ""), 115);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerAsMBean", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "void"), 119);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxTotalLabel", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "java.lang.String"), 340);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxTotalStatistic", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "java.lang.String"), 344);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getMaxAvgMonitor", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "patterntesting.runtime.monitor.ProfileMonitor"), 348);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxAvg", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "double"), 359);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxAvgLabel", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "java.lang.String"), 363);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxAvgStatistic", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "java.lang.String"), 367);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getMaxMaxMonitor", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "patterntesting.runtime.monitor.ProfileMonitor"), 371);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxMax", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "double"), 382);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxMaxLabel", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "java.lang.String"), 386);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxMaxStatistic", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "java.lang.String"), 390);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "reset", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "void"), 153);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getStatistics", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "javax.management.openmbean.TabularData"), 395);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logStatistic", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "void"), 445);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dumpStatistic", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "void"), 453);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProfileMonitor", "patterntesting.runtime.monitor.ProfileStatistic", "java.lang.Class:java.lang.String:", "clazz:method:", "", "patterntesting.runtime.monitor.ProfileMonitor"), 481);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProfileMonitor", "patterntesting.runtime.monitor.ProfileStatistic", "java.lang.String:", "signature:", "", "patterntesting.runtime.monitor.ProfileMonitor"), 493);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "java.lang.String"), 507);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "void"), 250);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getMaxHitsMonitor", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "patterntesting.runtime.monitor.ProfileMonitor"), 299);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxHits", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "int"), 313);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxHitsLabel", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "java.lang.String"), 317);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxHitsStatistic", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "java.lang.String"), 321);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getMaxTotalMonitor", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "patterntesting.runtime.monitor.ProfileMonitor"), 325);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxTotal", "patterntesting.runtime.monitor.ProfileStatistic", "", "", "", "double"), 336);
        log = LogFactoryImpl.getLog(ProfileStatistic.class);
        mbeanName = ProfileStatistic.createObjectName();
        rootMonitor = new SimpleProfileMonitor();
        jamonAvailable = ProfileStatistic.isJamon24Available();
        instance = new ProfileStatistic();
    }

    protected static boolean isJamon24Available() {
        String version;
        block3: {
            try {
                String resource = "/com/jamonapi/MonitorFactory.class";
                URL classURL = ProfileStatistic.class.getResource(resource);
                URI jarURI = ClasspathMonitor.getParent(classURL.toURI(), resource);
                JarFile jarfile = ClasspathMonitor.whichResourceJar(jarURI);
                Manifest manifest = jarfile.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                version = attributes.getValue("version");
                if (!version.equalsIgnoreCase("JAMon 2.4")) break block3;
                log.info((Object)"JAMon 2.4 available for profiling");
                return true;
            }
            catch (Exception exception) {
                log.info((Object)"JAMon not available, using simple profiling");
                return false;
            }
        }
        log.info((Object)(String.valueOf(version) + " not supported (only JAMon 2.4), using simple profiling"));
        return false;
    }

    private static ObjectName createObjectName() {
        String name = "patterntesting.runtime.monitor:type=ProfileStatistic";
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(name);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            log.info((Object)("can't create object name + '" + name + "'"));
        }
        return objectName;
    }

    protected ProfileStatistic() {
        try {
            this.registerAsMBean();
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    private void registerAsMBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                server.registerMBean(this, mbeanName);
                log.info((Object)(mbeanName + " successful registered as MBean"));
            }
            catch (Exception e) {
                log.info((Object)e);
            }
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    public static ProfileStatistic getInstance() {
        return instance;
    }

    public static void addAsShutdownHook() {
        Runtime.getRuntime().addShutdownHook(instance);
        if (log.isDebugEnabled()) {
            log.debug((Object)(instance + " registered as shutdown hook"));
        }
    }

    @Override
    public void reset() {
        try {
            ArrayList<String> labels = new ArrayList<String>();
            ProfileMonitor[] monitors = ProfileStatistic.getMonitors();
            int i = 0;
            while (i < monitors.length) {
                if (monitors[i].getHits() == 0) {
                    labels.add(monitors[i].getLabel());
                }
                ++i;
            }
            if (jamonAvailable) {
                JamonMonitorFactory.reset();
                JamonMonitorFactory.addMonitors(labels);
            } else {
                rootMonitor.reset();
                rootMonitor.addChildren(labels);
            }
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    public static void init(Class<?> cl) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("initializing monitors for " + cl + "..."));
        }
        ProfileStatistic.init(cl, cl.getMethods());
        ProfileStatistic.init(cl.getConstructors());
    }

    private static void init(Class<?> cl, Method[] methods) {
        int i = 0;
        while (i < methods.length) {
            Class<?> declaring = methods[i].getDeclaringClass();
            if (cl.equals(declaring)) {
                ProfileStatistic.init(methods[i]);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)(methods[i] + " not defined in " + cl + " -> no monitor initialized"));
            }
            ++i;
        }
    }

    private static void init(Method method) {
        if (method.getAnnotation(DontProfileMe.class) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("@DontProfileMe " + method + " is ignored"));
            }
            return;
        }
        MethodSignature sig = SignatureHelper.getAsSignature(method);
        ProfileMonitor mon = ProfileStatistic.getMonitor((Signature)sig);
        if (log.isTraceEnabled()) {
            log.trace((Object)(mon + " initialized"));
        }
    }

    private static void init(Constructor<?>[] ctors) {
        int i = 0;
        while (i < ctors.length) {
            ProfileStatistic.init(ctors[i]);
            ++i;
        }
    }

    private static void init(Constructor<?> ctor) {
        if (ctor.getAnnotation(DontProfileMe.class) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("@DontProfileMe " + ctor + " is ignored"));
            }
            return;
        }
        ConstructorSignature sig = SignatureHelper.getAsSignature(ctor);
        ProfileMonitor mon = ProfileStatistic.getMonitor((Signature)sig);
        if (log.isTraceEnabled()) {
            log.trace((Object)(mon + " initialized"));
        }
    }

    @Override
    public void run() {
        try {
            this.dumpStatistic();
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    public static ProfileMonitor start(Signature sig) {
        ProfileMonitor mon = null;
        if (jamonAvailable) {
            mon = JamonMonitorFactory.getMonitor(sig);
        } else {
            SimpleProfileMonitor parent = ProfileStatistic.getSimpleProfileMonitor(sig);
            mon = new SimpleProfileMonitor(sig, parent);
        }
        mon.start();
        return mon;
    }

    private static ProfileMonitor getMonitor(Signature sig) {
        if (jamonAvailable) {
            return JamonMonitorFactory.getMonitor(sig);
        }
        return ProfileStatistic.getSimpleProfileMonitor(sig);
    }

    private static SimpleProfileMonitor getSimpleProfileMonitor(Signature sig) {
        SimpleProfileMonitor monitor = rootMonitor.getMonitor(sig);
        if (monitor == null) {
            monitor = new SimpleProfileMonitor(sig, rootMonitor);
        }
        return monitor;
    }

    private static ProfileMonitor[] getMonitors() {
        if (jamonAvailable) {
            return JamonMonitorFactory.getMonitors();
        }
        return rootMonitor.getMonitors();
    }

    protected static ProfileMonitor[] getSortedMonitors() {
        Object[] monitors = ProfileStatistic.getMonitors();
        Arrays.sort(monitors);
        return monitors;
    }

    private ProfileMonitor getMaxHitsMonitor() {
        try {
            ProfileMonitor[] monitors = ProfileStatistic.getMonitors();
            ProfileMonitor max = monitors[0];
            int i = 1;
            while (i < monitors.length) {
                if (monitors[i].getHits() > max.getHits()) {
                    max = monitors[i];
                }
                ++i;
            }
            return max;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public int getMaxHits() {
        try {
            return this.getMaxHitsMonitor().getHits();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String getMaxHitsLabel() {
        try {
            return this.getMaxHitsMonitor().getLabel();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String getMaxHitsStatistic() {
        try {
            return this.getMaxHitsMonitor().toShortString();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    private ProfileMonitor getMaxTotalMonitor() {
        try {
            ProfileMonitor[] monitors = ProfileStatistic.getMonitors();
            ProfileMonitor max = monitors[0];
            int i = 1;
            while (i < monitors.length) {
                if (monitors[i].getTotal() > max.getTotal()) {
                    max = monitors[i];
                }
                ++i;
            }
            return max;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public double getMaxTotal() {
        try {
            return this.getMaxTotalMonitor().getTotal();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String getMaxTotalLabel() {
        try {
            return this.getMaxTotalMonitor().getLabel();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String getMaxTotalStatistic() {
        try {
            return this.getMaxTotalMonitor().toShortString();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    private ProfileMonitor getMaxAvgMonitor() {
        try {
            ProfileMonitor[] monitors = ProfileStatistic.getMonitors();
            ProfileMonitor max = monitors[0];
            int i = 1;
            while (i < monitors.length) {
                if (monitors[i].getAvg() > max.getAvg()) {
                    max = monitors[i];
                }
                ++i;
            }
            return max;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public double getMaxAvg() {
        try {
            return this.getMaxAvgMonitor().getAvg();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String getMaxAvgLabel() {
        try {
            return this.getMaxAvgMonitor().getLabel();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String getMaxAvgStatistic() {
        try {
            return this.getMaxAvgMonitor().toShortString();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    private ProfileMonitor getMaxMaxMonitor() {
        try {
            ProfileMonitor[] monitors = ProfileStatistic.getMonitors();
            ProfileMonitor max = monitors[0];
            int i = 1;
            while (i < monitors.length) {
                if (monitors[i].getMax() > max.getMax()) {
                    max = monitors[i];
                }
                ++i;
            }
            return max;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public double getMaxMax() {
        try {
            return this.getMaxMaxMonitor().getMax();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String getMaxMaxLabel() {
        try {
            return this.getMaxMaxMonitor().getLabel();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String getMaxMaxStatistic() {
        try {
            return this.getMaxMaxMonitor().toShortString();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public TabularData getStatistics() {
        try {
            ProfileMonitor[] monitors;
            TabularDataSupport data;
            CompositeType rowType;
            block7: {
                String[] itemNames = new String[]{"Label", "Units", "Hits", "Avg", "Total", "Min", "Max", "Active", "AvgActive", "MaxActive", "FirstAccess", "LastAccess"};
                String[] itemDescriptions = new String[]{"method name", "time unit (e.g. ms)", "number of hits", "average time", "total time", "minimal time", "maximal time", "active threads", "average number of threads", "maximal number of threads", "first access", "last access"};
                OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DATE, SimpleType.DATE};
                rowType = new CompositeType("propertyType", "property entry", itemNames, itemDescriptions, itemTypes);
                TabularType tabularType = new TabularType("propertyTabularType", "properties tabular", rowType, itemNames);
                data = new TabularDataSupport(tabularType);
                monitors = ProfileStatistic.getSortedMonitors();
                if (monitors != null) break block7;
                log.warn((Object)"can't find monitors");
                return null;
            }
            try {
                int i = 0;
                while (i < monitors.length) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("Label", monitors[i].getLabel());
                    map.put("Units", monitors[i].getUnits());
                    map.put("Hits", monitors[i].getHits());
                    map.put("Avg", monitors[i].getAvg());
                    map.put("Total", monitors[i].getTotal());
                    map.put("Min", monitors[i].getMin());
                    map.put("Max", monitors[i].getMax());
                    map.put("Active", monitors[i].getActive());
                    map.put("AvgActive", monitors[i].getAvgActive());
                    map.put("MaxActive", monitors[i].getMaxActive());
                    map.put("FirstAccess", monitors[i].getFirstAccess());
                    map.put("LastAccess", monitors[i].getLastAccess());
                    CompositeDataSupport compData = new CompositeDataSupport(rowType, map);
                    data.put(compData);
                    ++i;
                }
                return data;
            }
            catch (OpenDataException e) {
                log.error((Object)"can't create TabularData for log settings", (Throwable)e);
                return null;
            }
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public void logStatistic() {
        try {
            ProfileMonitor[] monitors;
            log.info((Object)"----- Profile Statistic -----");
            ProfileMonitor[] profileMonitorArray = monitors = ProfileStatistic.getSortedMonitors();
            int n = monitors.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileMonitor profMon = profileMonitorArray[n2];
                log.info((Object)profMon);
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public void dumpStatistic() {
        try {
            try {
                File dumpFile = File.createTempFile("profile", ".csv");
                BufferedWriter writer = new BufferedWriter(new FileWriter(dumpFile));
                ProfileMonitor[] monitors = ProfileStatistic.getSortedMonitors();
                writer.write(monitors[0].toCsvHeadline());
                writer.newLine();
                ProfileMonitor[] profileMonitorArray = monitors;
                int n = monitors.length;
                int n2 = 0;
                while (n2 < n) {
                    ProfileMonitor profMon = profileMonitorArray[n2];
                    writer.write(profMon.toCsvString());
                    writer.newLine();
                    ++n2;
                }
                writer.close();
                log.info((Object)("profiling data dumped to " + dumpFile));
            }
            catch (IOException ioe) {
                log.info((Object)("can't dump statistic (" + ioe + ")"));
            }
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @MayReturnNull
    public ProfileMonitor getProfileMonitor(Class<?> clazz, String string) {
        Class<?> clazz2 = clazz;
        String string2 = string;
        try {
            void method;
            void clazz3;
            return this.getProfileMonitor(String.valueOf(clazz3.getName()) + "." + (String)method);
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, clazz2, (Object)string2));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @MayReturnNull
    public ProfileMonitor getProfileMonitor(String string) {
        String string2 = string;
        try {
            void signature;
            ProfileMonitor[] profileMonitorArray = ProfileStatistic.getMonitors();
            int n = profileMonitorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileMonitor profMon = profileMonitorArray[n2];
                if (signature.equals(profMon.getLabel())) {
                    return profMon;
                }
                ++n2;
            }
            log.trace((Object)("no ProfileMonitor for " + (String)signature + " found"));
            return null;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)string2));
            }
            throw throwable;
        }
    }

    @Override
    public String toString() {
        try {
            return mbeanName.toString();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }
}

