/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.io;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.junit.Assert;
import org.junit.Test;
import patterntesting.runtime.io.FileHelper;

public class IOExceptionTest {
    private static final Log log = LogFactoryImpl.getLog(IOExceptionTest.class);
    private File missingDir = new File("not", "existing");
    static /* synthetic */ Class class$0;

    @Test
    public final void testCreateTempFile() {
        try {
            File.createTempFile("exception", "expected", this.missingDir);
            Assert.fail((String)("IOException expected for directory " + this.missingDir));
        }
        catch (IOException expected) {
            this.checkMessage(expected);
        }
    }

    @Test
    public final void testCreateTempFileWithDirPrefix() {
        try {
            File.createTempFile(this.missingDir.toString(), "test");
            Assert.fail((String)("IOException expected for prefix " + this.missingDir));
        }
        catch (IOException expected) {
            this.checkMessage(expected);
        }
    }

    @Test
    public final void testCreateTempFileWithDirSuffix() {
        try {
            File.createTempFile("test", this.missingDir.toString());
            Assert.fail((String)("IOException expected for suffix " + this.missingDir));
        }
        catch (IOException expected) {
            this.checkMessage(expected);
        }
    }

    @Test
    public final void testCreateNewFile() {
        File file = FileHelper.getTmpdir(this.missingDir);
        try {
            boolean ok = file.createNewFile();
            Assert.assertEquals((Object)false, (Object)ok);
        }
        catch (IOException expected) {
            this.checkMessage(expected);
        }
    }

    private void checkMessage(IOException expected) {
        log.info((Object)expected);
        String msg = expected.getMessage();
        Assert.assertFalse((String)("filename missing in '" + msg + "'"), (boolean)msg.equals("No such file or directory"));
    }
}

