/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.junit.BeforeClass;
import org.junit.Test;
import patterntesting.runtime.init.CrashBean;

public class InitializationTest {
    private static final Log log = LogFactoryImpl.getLog(InitializationTest.class);
    private static final String testClassName = CrashBean.class.getName();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    @BeforeClass
    public static void setupBeforeClass() {
        try {
            Class<?> cl = Class.forName(testClassName);
            log.info((Object)(cl + " succesful loaded"));
        }
        catch (Throwable t) {
            log.info((Object)(String.valueOf(testClassName) + " can't be loaded"), t);
        }
    }

    @Test
    public final void testCallStaticMethod() {
        log.info((Object)("date: " + CrashBean.getDate()));
    }

    @Test
    public final void testNoClassDefFoundError() throws ClassNotFoundException {
        Class<?> cl = Class.forName(testClassName);
        log.info((Object)("got " + cl));
    }

    @Test
    public final void testClassLoading() throws ClassNotFoundException {
        ClassLoader loader = this.getClass().getClassLoader();
        Class<?> cl = loader.loadClass(testClassName);
        log.info((Object)("got " + cl));
    }
}

