/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.xml;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLReaderFactoryTest {
    private static final Log log = LogFactoryImpl.getLog(XMLReaderFactoryTest.class);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    @Test
    public void testCreateXMLReader() {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            log.info((Object)("xmlReader=" + xmlReader));
            Assert.assertNotNull((Object)xmlReader);
        }
        catch (SAXException saxe) {
            log.info((Object)saxe.getMessage());
            Assert.assertTrue((boolean)StringUtils.contains((String)saxe.getMessage(), (String)"check system resource"));
        }
    }

    @Test
    public void testSetProperty() throws SAXException {
        String propertyName = "org.xml.sax.driver";
        try {
            System.setProperty(propertyName, "org.apache.xerces.parsers.SAXParser");
            this.checkCreateXMLReader(SAXException.class, "check property \"" + propertyName + "\"");
        }
        finally {
            System.getProperties().remove(propertyName);
        }
    }

    private void checkCreateXMLReader(Class<? extends Throwable> clazz, String expected) {
        try {
            XMLReaderFactory.createXMLReader();
            Assert.fail((String)(String.valueOf(clazz.getSimpleName()) + "(" + expected + ") expected"));
        }
        catch (Throwable t) {
            log.debug((Object)t.getMessage(), t);
            Assert.assertEquals(clazz, t.getClass());
            String msg = t.getMessage();
            Assert.assertTrue((String)(String.valueOf('\"') + msg + "\" does not end with \"" + expected + '\"'), (boolean)msg.endsWith(expected));
        }
    }
}

