/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;
import patterntesting.runtime.xml.SAXHelper;

public class SAXHelperTest {
    private static final String driverClassName = "nirwana.org.apache.xerces.parsers.SAXParser";

    @After
    public void tearDown() {
        System.getProperties().remove("org.xml.sax.driver");
    }

    @Test
    public void testBetterSAXException() throws InstantiationException, IllegalAccessException {
        SAXException saxe = SAXHelperTest.createSAXException();
        SAXHelperTest.checkSAXException(saxe, saxe.getMessage());
    }

    @Test
    public void testBetterSAXExceptionWithSystemProperty() throws InstantiationException, IllegalAccessException {
        System.setProperty("org.xml.sax.driver", "something.else");
        SAXException saxe = SAXHelperTest.createSAXException();
        SAXHelperTest.checkSAXException(saxe, saxe.getMessage());
    }

    @Test
    public void testBetterSAXExceptionWithWrongSystemProperty() throws InstantiationException, IllegalAccessException {
        System.setProperty("org.xml.sax.driver", driverClassName);
        SAXException saxe = SAXHelperTest.createSAXException();
        String expected = String.valueOf(saxe.getMessage()) + " - check property \"" + "org.xml.sax.driver" + "\"";
        SAXHelperTest.checkSAXException(saxe, expected);
    }

    @Test
    public void testDriverResource() throws IOException {
        String service = "META-INF/services/org.xml.sax.driver";
        InputStream in = ClassLoader.getSystemResourceAsStream(service);
        Assert.assertNotNull((String)("can't load " + service), (Object)in);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF8"));
            String className = reader.readLine();
            Assert.assertEquals((Object)"nirwana.test.driver", (Object)className);
        }
        finally {
            in.close();
        }
    }

    @Test
    public void testBetterSAXExceptionWithSystemResource() {
        String className = "nirwana.test.driver";
        SAXException saxe = SAXHelperTest.createSAXException(className);
        String expected = String.valueOf(saxe.getMessage()) + " - check system resource \"" + "META-INF/services/org.xml.sax.driver" + "\"";
        SAXHelperTest.checkSAXException(saxe, expected);
    }

    private static void checkSAXException(SAXException orig, String expected) {
        SAXException betterException = SAXHelper.betterSAXException(orig);
        Assert.assertEquals((Object)expected, (Object)betterException.getMessage());
    }

    private static SAXException createSAXException() {
        return SAXHelperTest.createSAXException(driverClassName);
    }

    private static SAXException createSAXException(String className) {
        ClassNotFoundException e = new ClassNotFoundException(className);
        return new SAXException("SAX2 driver class " + className + " not found", e);
    }
}

