/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.runtime.reflect.Factory;
import patterntesting.runtime.annotation.LogThrowable;
import patterntesting.runtime.log.LogThrowableAspect;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.reflect.ConstructorSignatureImpl;
import patterntesting.runtime.util.reflect.MethodSignatureImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureHelper {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        Factory factory = new Factory("SignatureHelper.java", Class.forName("patterntesting.runtime.util.SignatureHelper"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "patterntesting.runtime.util.SignatureHelper", "", "", ""), 37);
        log = LogFactoryImpl.getLog(SignatureHelper.class);
    }

    public SignatureHelper() {
        try {
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    public static String getAsString(Signature sig) {
        try {
            CodeSignature codeSig = (CodeSignature)sig;
            String name = SignatureHelper.getAsString(sig.getDeclaringTypeName(), sig);
            Object[] params = codeSig.getParameterTypes();
            return String.valueOf(name) + "(" + Converter.toShortString(params) + ")";
        }
        catch (Exception e) {
            log.debug((Object)("can't get '" + sig + "' as String"), (Throwable)e);
            return sig.toString();
        }
    }

    public static String getAsString(String type, Signature sig) {
        String name = sig.getName();
        if (name.equals("<init>")) {
            return "new " + type;
        }
        return String.valueOf(type) + "." + name;
    }

    public static MethodSignature getAsSignature(Method method) {
        return new MethodSignatureImpl(method);
    }

    public static ConstructorSignature getAsSignature(Constructor<?> ctor) {
        return new ConstructorSignatureImpl(ctor);
    }

    public static Signature getAsSignature(String label) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        if (label.startsWith("new ")) {
            return SignatureHelper.getAsConstructorSignature(label);
        }
        String classDotMethod = StringUtils.substringBefore((String)label, (String)"(");
        String className = StringUtils.substringBeforeLast((String)classDotMethod, (String)".");
        String methodName = StringUtils.substringAfterLast((String)classDotMethod, (String)".");
        Class<?>[] params = SignatureHelper.getParameterTypes(label);
        return SignatureHelper.getAsSignature(Class.forName(className), methodName, params);
    }

    private static Signature getAsSignature(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Method method = clazz.getMethod(methodName, parameterTypes);
        return SignatureHelper.getAsSignature(method);
    }

    private static ConstructorSignature getAsConstructorSignature(String label) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        String ctor = StringUtils.substringAfterLast((String)label, (String)" ").trim();
        String className = StringUtils.substringBefore((String)ctor, (String)"(");
        Class<?>[] params = SignatureHelper.getParameterTypes(label);
        return SignatureHelper.getAsConstructorSignature(Class.forName(className), params);
    }

    private static ConstructorSignature getAsConstructorSignature(Class<?> clazz, Class<?>[] parameterTypes) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Constructor<?> ctor = clazz.getConstructor(parameterTypes);
        return SignatureHelper.getAsSignature(ctor);
    }

    private static Class<?>[] getParameterTypes(String label) throws ClassNotFoundException {
        String parameters = StringUtils.substringAfter((String)label, (String)"(");
        parameters = StringUtils.substringBefore((String)parameters, (String)")");
        String[] params = StringUtils.split((String)parameters, (char)',');
        Class[] parameterTypes = new Class[params.length];
        int i = 0;
        while (i < params.length) {
            parameterTypes[i] = Class.forName(params[i].trim());
            ++i;
        }
        return parameterTypes;
    }
}

