/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.SimpleProfileMonitor;
import patterntesting.runtime.util.ThreadUtil;

public abstract class ProfileMonitorTest {
    private static final Log log = LogFactoryImpl.getLog(ProfileMonitorTest.class);
    protected ProfileMonitor profMon;
    static /* synthetic */ Class class$0;

    @Before
    public void setUp() {
        this.profMon = new SimpleProfileMonitor();
    }

    @Test
    public final void testGetHits() {
        this.profMon.add(0.1);
        this.profMon.add(0.2);
        log.info((Object)("profMon = " + this.profMon));
        Assert.assertEquals((long)2L, (long)this.profMon.getHits());
        Assert.assertEquals((double)0.2, (double)this.profMon.getLastValue(), (double)0.01);
    }

    @Test
    public final void testMinMax() {
        this.profMon.add(0.1);
        this.profMon.add(0.2);
        this.profMon.add(0.3);
        log.info((Object)("profMon = " + this.profMon));
        Assert.assertEquals((double)0.1, (double)this.profMon.getMin(), (double)0.01);
        Assert.assertEquals((double)0.3, (double)this.profMon.getMax(), (double)0.01);
    }

    @Test
    public final void testLastValue() {
        long t0 = System.currentTimeMillis();
        this.profMon.start();
        this.profMon.stop();
        long t = System.currentTimeMillis() - t0;
        double diff = (double)t - this.profMon.getLastValue();
        log.info((Object)("measured difference: " + diff + " ms"));
        Assert.assertEquals((double)8.0, (double)diff, (double)16.0);
    }

    @Test
    public final void testGetAvg() {
        this.profMon.reset();
        this.profMon.start();
        ThreadUtil.sleep();
        this.profMon.stop();
        Assert.assertEquals((double)this.profMon.getLastValue(), (double)this.profMon.getAvg(), (double)16.0);
    }

    @Test
    public final void testAdd() {
        this.profMon.reset();
        this.profMon.add(0.1);
        Assert.assertEquals((double)this.profMon.getLastValue(), (double)0.1, (double)0.01);
    }
}

