/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.monitor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.management.JMException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import patterntesting.runtime.annotation.LogThrowable;
import patterntesting.runtime.annotation.ProfileMe;
import patterntesting.runtime.jmx.MBeanHelper;
import patterntesting.runtime.log.LogThrowableAspect;
import patterntesting.runtime.monitor.AbstractProfileAspect;
import patterntesting.runtime.monitor.ClassWalker;
import patterntesting.runtime.monitor.ClasspathMonitorMBean;
import patterntesting.runtime.monitor.ProfileAspect;
import patterntesting.runtime.monitor.ProfileMonitor;
import patterntesting.runtime.monitor.ProfileStatistic;
import patterntesting.runtime.util.Converter;
import patterntesting.runtime.util.ObjectComparator;
import patterntesting.runtime.util.ReflectionHelper;
import patterntesting.runtime.util.ThreadUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathMonitor
extends Thread
implements ClasspathMonitorMBean {
    private static final long serialVersionUID = 20090328L;
    private static final Log log;
    private final ClassLoader cloader;
    private final String[] bootClassPath;
    private final String[] classpath;
    private String[] loadedClasses;
    private final Set<String> unusedClasses;
    private final String[] classpathClasses;
    private List<Class<?>> doubletList;
    private static ClasspathMonitor instance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;

    static {
        Factory factory = new Factory("ClasspathMonitor.java", Class.forName("patterntesting.runtime.monitor.ClasspathMonitor"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", ""), 74);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createClasspathClasses", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 86);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "whichClassPath", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "classname:", "", "java.net.URI"), 262);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "whichClassPath", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.Class:", "clazz:", "", "java.net.URI"), 273);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "whichResourcePath", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "resource:", "", "java.net.URI"), 283);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "whichClassJar", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.Class:", "clazz:", "", "java.util.jar.JarFile"), 291);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "whichClassJar", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "classname:", "", "java.util.jar.JarFile"), 295);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "whichResourceJar", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "resource:", "", "java.util.jar.JarFile"), 300);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResources", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "name:", "", "java.util.Enumeration"), 325);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNoResources", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "name:", "", "int"), 355);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNoClasses", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.Class:", "cl:", "", "int"), 371);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNoClasses", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "classname:", "", "int"), 382);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getClasspath", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "key:", "", "[Ljava.lang.String;"), 116);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDoublet", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "name:", "", "boolean"), 390);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDoublet", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.Class:", "clazz:", "", "boolean"), 415);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirstDoublet", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "name:", "", "java.net.URL"), 425);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDoublet", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:int:", "name:nr:", "", "java.net.URL"), 433);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDoublet", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.Class:int:", "clazz:nr:", "", "java.net.URL"), 444);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "logDoublets", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "name:", "", "void"), 449);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getDoubletList", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.util.List"), 470);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDoublets", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 494);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDoubletClasspath", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 508);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDoubletClasspathSet", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.util.SortedSet"), 515);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getRealClasspath", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 143);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassLoaderDetails", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.lang.String"), 543);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1a", "dumpFields", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.StringBuffer:java.lang.Class:java.lang.Object:", "sbuf:cl:obj:", "", "void"), 554);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLoadedPackageArray", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.Package;"), 578);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLoadedPackages", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 596);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLoadedPackagesAsString", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.lang.String"), 612);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getLoadedClassList", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.ClassLoader:", "cloader:", "", "java.util.List"), 650);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getLoadedClassList", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.util.List"), 668);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getLoadedClasses", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 679);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLoadedClassesAsString", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.lang.String"), 692);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUnusedClasses", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 712);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTomcatClasspath", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 154);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClasspathClasses", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 732);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getClasspathClassSet", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.util.Set"), 737);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "addClassesFromDir", "patterntesting.runtime.monitor.ClasspathMonitor", "java.util.Set:java.io.File:", "classSet:dir:", "java.io.IOException:", "void"), 761);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "addClassesFromArchive", "patterntesting.runtime.monitor.ClasspathMonitor", "java.util.Set:java.io.File:", "classSet:archive:", "java.io.IOException:", "void"), 769);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUsedClasspathSet", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.util.SortedSet"), 791);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUsedClasspath", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 812);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUnusedClasspath", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 845);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBootClasspath", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 868);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClasspath", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "[Ljava.lang.String;"), 878);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getParent", "patterntesting.runtime.monitor.ClasspathMonitor", "java.net.URI:java.lang.Class:", "path:clazz:", "", "java.net.URI"), 894);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkClassloader", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.ClassLoader:", "classloader:", "", "java.lang.ClassLoader"), 171);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "void"), 946);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logMe", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "void"), 953);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dumpMe", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "void"), 978);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "patterntesting.runtime.monitor.ClasspathMonitor", "", "", "", "java.lang.String"), 1019);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "whichResource", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "name:", "", "java.net.URI"), 183);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "whichResource", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:java.lang.ClassLoader:", "name:classloader:", "", "java.net.URI"), 216);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "whichClass", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.String:", "name:", "", "java.net.URI"), 238);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "whichClass", "patterntesting.runtime.monitor.ClasspathMonitor", "java.lang.Class:", "clazz:", "", "java.net.URI"), 252);
        log = LogFactoryImpl.getLog(ClasspathMonitor.class);
        instance = new ClasspathMonitor();
    }

    public ClasspathMonitor() {
        try {
            this.bootClassPath = this.getClasspath("sun.boot.class.path");
            this.loadedClasses = new String[0];
            this.doubletList = new ArrayList();
            this.cloader = this.checkClassloader(this.getClass().getClassLoader());
            this.classpath = this.getRealClasspath();
            this.unusedClasses = this.getClasspathClassSet();
            this.classpathClasses = this.createClasspathClasses();
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @ProfileMe
    private String[] createClasspathClasses() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        return (String[])ClasspathMonitor.createClasspathClasses_aroundBody1$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    public static ClasspathMonitor getInstance() {
        return instance;
    }

    public static void registerAsMBean() {
        block2: {
            try {
                MBeanHelper.registerMBean(ClasspathMonitor.getInstance());
            }
            catch (JMException e) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)(instance + " can't be registered as MBean (" + e + ")"));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String[] getClasspath(String string) {
        String string2 = string;
        try {
            void key;
            String classpath = System.getProperty((String)key);
            if (classpath == null) {
                log.info((Object)(String.valueOf(key) + " is not set (not a SunVM?)"));
                return new String[0];
            }
            return ClasspathMonitor.splitClasspath(classpath);
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2));
            }
            throw throwable;
        }
    }

    private String[] getRealClasspath() {
        try {
            String classloaderName = this.cloader.getClass().getName();
            if (classloaderName.equals("org.apache.catalina.loader.WebappClassLoader")) {
                return this.getTomcatClasspath();
            }
            log.trace((Object)"using 'java.class.path' to get classpath...");
            return this.getClasspath("java.class.path");
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    private String[] getTomcatClasspath() {
        try {
            try {
                Field field = ReflectionHelper.getField(this.cloader.getClass(), "repositoryURLs");
                URL[] repositoryURLs = (URL[])field.get(this.cloader);
                String[] cp = new String[repositoryURLs.length];
                int i = 0;
                while (i < cp.length) {
                    File f = Converter.toFile(repositoryURLs[i].toURI());
                    cp[i] = f.getAbsolutePath();
                    ++i;
                }
                return cp;
            }
            catch (Exception e) {
                log.warn((Object)"can't access field 'repositoryURLs'", (Throwable)e);
                return this.getClasspath("java.class.path");
            }
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    private ClassLoader checkClassloader(ClassLoader classLoader) {
        ClassLoader classLoader2 = classLoader;
        try {
            ClassLoader classloader;
            if (classloader == null) {
                classloader = Thread.currentThread().getContextClassLoader();
                log.warn((Object)("null ClassLoader given - replaced by " + classloader));
            }
            return classloader;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)classLoader2));
            }
            throw throwable;
        }
    }

    @Override
    @ProfileMe
    public URI whichResource(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string2);
        return (URI)ClasspathMonitor.whichResource_aroundBody3$advice(this, string2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @ProfileMe
    public URI whichResource(String string, ClassLoader classLoader) {
        String string2 = string;
        ClassLoader classLoader2 = classLoader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string2, (Object)classLoader2);
        return (URI)ClasspathMonitor.whichResource_aroundBody5$advice(this, string2, classLoader2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @Override
    @ProfileMe
    public URI whichClass(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string2);
        return (URI)ClasspathMonitor.whichClass_aroundBody7$advice(this, string2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @ProfileMe
    public URI whichClass(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, clazz2);
        return (URI)ClasspathMonitor.whichClass_aroundBody9$advice(this, clazz2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public URI whichClassPath(String string) {
        String string2 = string;
        try {
            void classname;
            String resource = Converter.classToResource((String)classname);
            return this.whichResourcePath(resource);
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string2));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public URI whichClassPath(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        try {
            void clazz3;
            return this.whichClassPath(clazz3.getName());
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, clazz2));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public URI whichResourcePath(String string) {
        String string2 = string;
        try {
            void resource;
            URI uri = this.whichResource((String)resource);
            if (uri == null) {
                return null;
            }
            return ClasspathMonitor.getParent(uri, (String)resource);
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public JarFile whichClassJar(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        try {
            void clazz3;
            return this.whichClassJar(clazz3.getName());
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, clazz2));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public JarFile whichClassJar(String string) {
        String string2 = string;
        try {
            void classname;
            String resource = Converter.classToResource((String)classname);
            return this.whichResourceJar(resource);
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string2));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public JarFile whichResourceJar(String string) {
        String string2 = string;
        try {
            void resource;
            return ClasspathMonitor.whichResourceJar(this.whichResourcePath((String)resource));
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string2));
            }
            throw throwable;
        }
    }

    public static JarFile whichResourceJar(URI resource) {
        if (resource == null) {
            return null;
        }
        File file = Converter.toFile(resource);
        try {
            return new JarFile(file);
        }
        catch (IOException ioe) {
            log.debug((Object)("can't read " + file), (Throwable)ioe);
            return null;
        }
    }

    @ProfileMe
    public Enumeration<URL> getResources(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string2);
        return (Enumeration)ClasspathMonitor.getResources_aroundBody11$advice(this, string2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    public static URL getResource(String name) {
        return ClasspathMonitor.class.getResource(name);
    }

    @Override
    @ProfileMe
    public int getNoResources(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string2);
        return Conversions.intValue((Object)ClasspathMonitor.getNoResources_aroundBody13$advice(this, string2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint));
    }

    /*
     * WARNING - void declaration
     */
    public int getNoClasses(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        try {
            void cl;
            return this.getNoClasses(cl.getName());
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, clazz2));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getNoClasses(String string) {
        String string2 = string;
        try {
            void classname;
            return this.getNoResources(Converter.classToResource((String)classname));
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string2));
            }
            throw throwable;
        }
    }

    @Override
    @ProfileMe
    public boolean isDoublet(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string2);
        return Conversions.booleanValue((Object)ClasspathMonitor.isDoublet_aroundBody15$advice(this, string2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint));
    }

    @ProfileMe
    public boolean isDoublet(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, clazz2);
        return Conversions.booleanValue((Object)ClasspathMonitor.isDoublet_aroundBody17$advice(this, clazz2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public URL getFirstDoublet(String string) {
        String string2 = string;
        try {
            void name;
            return this.getDoublet((String)name, 1);
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)string2));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public URL getDoublet(String string, int n) {
        String string2 = string;
        int n2 = n;
        try {
            void name;
            Enumeration<URL> resources = this.getResources((String)name);
            int i = 0;
            while (resources.hasMoreElements()) {
                void nr;
                URL url = resources.nextElement();
                if (i == nr) {
                    return url;
                }
                ++i;
            }
            return null;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)string2, (Object)Conversions.intObject((int)n2)));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public URL getDoublet(Class<?> clazz, int n) {
        Class<?> clazz2 = clazz;
        int n2 = n;
        try {
            void nr;
            void clazz3;
            String resource = Converter.classToResource(clazz3.getName());
            return this.getDoublet(resource, (int)nr);
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, clazz2, (Object)Conversions.intObject((int)n2)));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logDoublets(String string) {
        String string2 = string;
        try {
            if (log.isTraceEnabled()) {
                void name;
                Vector<URL> doublets = new Vector<URL>();
                Enumeration<URL> resources = this.getResources((String)name);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    doublets.add(url);
                }
                log.trace((Object)(String.valueOf(name) + " doublets found: " + doublets));
            }
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string2));
            }
            throw throwable;
        }
    }

    @ProfileMe
    public synchronized List<Class<?>> getDoubletList() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        return (List)ClasspathMonitor.getDoubletList_aroundBody19$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @Override
    @ProfileMe
    public String[] getDoublets() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        return (String[])ClasspathMonitor.getDoublets_aroundBody21$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @Override
    @ProfileMe
    public String[] getDoubletClasspath() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        return (String[])ClasspathMonitor.getDoubletClasspath_aroundBody23$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @ProfileMe
    public SortedSet<URI> getDoubletClasspathSet() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        return (SortedSet)ClasspathMonitor.getDoubletClasspathSet_aroundBody25$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @ProfileMe
    public String getClassLoaderDetails() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        return (String)ClasspathMonitor.getClassLoaderDetails_aroundBody27$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @ProfileMe
    private static final void dumpFields(StringBuffer stringBuffer, Class<?> clazz, Object object) {
        StringBuffer stringBuffer2 = stringBuffer;
        Class<?> clazz2 = clazz;
        Object object2 = object;
        Object[] objectArray = new Object[]{stringBuffer2, clazz2, object2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, null, null, (Object[])objectArray);
        ClasspathMonitor.dumpFields_aroundBody29$advice(stringBuffer2, clazz2, object2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @ProfileMe
    public Package[] getLoadedPackageArray() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        return (Package[])ClasspathMonitor.getLoadedPackageArray_aroundBody31$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @Override
    public String[] getLoadedPackages() {
        try {
            Package[] packages = this.getLoadedPackageArray();
            Object[] strings = new String[packages.length];
            int i = 0;
            while (i < packages.length) {
                strings[i] = packages[i].toString();
                ++i;
            }
            Arrays.sort(strings);
            return strings;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    public String getLoadedPackagesAsString() {
        try {
            String[] packages = this.getLoadedPackages();
            StringBuffer sbuf = new StringBuffer();
            int i = 0;
            while (i < packages.length) {
                sbuf.append(packages[i]);
                sbuf.append('\n');
                ++i;
            }
            return sbuf.toString().trim();
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    private static Method getMethod(Class<?> cl, String name) {
        try {
            return cl.getDeclaredMethod(name, new Class[0]);
        }
        catch (SecurityException e) {
            log.warn((Object)("can't get method " + cl + "#" + name), (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class<?> superclass = cl.getSuperclass();
            if (superclass == null) {
                return null;
            }
            return ClasspathMonitor.getMethod(superclass, name);
        }
    }

    @ProfileMe
    private static List<Class<?>> getLoadedClassList(ClassLoader classLoader) {
        ClassLoader classLoader2 = classLoader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, null, null, (Object)classLoader2);
        return (List)ClasspathMonitor.getLoadedClassList_aroundBody33$advice(classLoader2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @ProfileMe
    public synchronized List<Class<?>> getLoadedClassList() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this);
        return (List)ClasspathMonitor.getLoadedClassList_aroundBody35$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @Override
    public synchronized String[] getLoadedClasses() {
        try {
            List<Class<?>> classes = this.getLoadedClassList();
            if (classes.size() != this.loadedClasses.length) {
                this.loadedClasses = new String[classes.size()];
                int i = 0;
                while (i < this.loadedClasses.length) {
                    this.loadedClasses[i] = classes.get(i).toString();
                    ++i;
                }
                Arrays.sort(this.loadedClasses);
            }
            return this.loadedClasses;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @ProfileMe
    public String getLoadedClassesAsString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this);
        return (String)ClasspathMonitor.getLoadedClassesAsString_aroundBody37$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @Override
    @ProfileMe
    public String[] getUnusedClasses() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this);
        return (String[])ClasspathMonitor.getUnusedClasses_aroundBody39$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @Override
    public String[] getClasspathClasses() {
        try {
            return this.classpathClasses;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @ProfileMe
    private Set<String> getClasspathClassSet() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this);
        return (Set)ClasspathMonitor.getClasspathClassSet_aroundBody41$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    private static void addClasses(Set<String> classSet, File path) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("adding classes from " + path.getAbsolutePath() + "..."));
        }
        try {
            if (path.isDirectory()) {
                ClasspathMonitor.addClassesFromDir(classSet, path);
            } else {
                ClasspathMonitor.addClassesFromArchive(classSet, path);
            }
        }
        catch (IOException iOException) {
            log.warn((Object)("can't add classes from " + path.getAbsolutePath()));
        }
    }

    @ProfileMe
    private static void addClassesFromDir(Set<String> set, File file) throws IOException {
        Set<String> set2 = set;
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, null, null, set2, (Object)file2);
        ClasspathMonitor.addClassesFromDir_aroundBody43$advice(set2, file2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @ProfileMe
    private static void addClassesFromArchive(Set<String> set, File file) throws IOException {
        Set<String> set2 = set;
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, null, null, set2, (Object)file2);
        ClasspathMonitor.addClassesFromArchive_aroundBody45$advice(set2, file2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @ProfileMe
    public SortedSet<URI> getUsedClasspathSet() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this);
        return (SortedSet)ClasspathMonitor.getUsedClasspathSet_aroundBody47$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @Override
    @ProfileMe
    public String[] getUsedClasspath() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this);
        return (String[])ClasspathMonitor.getUsedClasspath_aroundBody49$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    private static String[] getAsArray(Set<URI> classpathSet) {
        Object[] classpath = new String[classpathSet.size()];
        Object[] a = classpathSet.toArray();
        int i = 0;
        while (i < classpath.length) {
            URI uri = (URI)a[i];
            classpath[i] = uri.getPath();
            if (StringUtils.isEmpty((String)classpath[i])) {
                classpath[i] = StringUtils.substringAfterLast((String)uri.toString(), (String)":");
            }
            if (((String)classpath[i]).endsWith(File.separator)) {
                classpath[i] = ((String)classpath[i]).substring(0, ((String)classpath[i]).length() - 1);
            }
            ++i;
        }
        Arrays.sort(classpath);
        return classpath;
    }

    @Override
    @ProfileMe
    public String[] getUnusedClasspath() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this);
        return (String[])ClasspathMonitor.getUnusedClasspath_aroundBody51$advice(this, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    @Override
    public String[] getBootClasspath() {
        try {
            return this.bootClassPath;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public String[] getClasspath() {
        try {
            return this.classpath;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    private static String[] splitClasspath(String classpath) {
        String separator = System.getProperty("path.separator", ":");
        String[] cp = StringUtils.split((String)classpath, (String)separator);
        int i = 0;
        while (i < cp.length) {
            if (cp[i].endsWith(File.separator)) {
                cp[i] = cp[i].substring(0, cp[i].length() - 1);
            }
            ++i;
        }
        return cp;
    }

    @ProfileMe
    private static URI getParent(URI uRI, Class<?> clazz) {
        URI uRI2 = uRI;
        Class<?> clazz2 = clazz;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, null, null, (Object)uRI2, clazz2);
        return (URI)ClasspathMonitor.getParent_aroundBody53$advice(uRI2, clazz2, joinPoint, ProfileAspect.aspectOf(), null, joinPoint);
    }

    public static URI getParent(URI path, String resource) {
        String parent = StringUtils.removeEnd((String)path.toString(), (String)resource);
        if (parent.endsWith(File.separator)) {
            parent = parent.substring(0, parent.length() - 1);
        }
        if (parent.endsWith("!")) {
            parent = parent.substring(0, parent.length() - 1);
        }
        try {
            return new URI(parent);
        }
        catch (URISyntaxException canthappen) {
            log.error((Object)("can't extract " + resource + " from " + path), (Throwable)canthappen);
            return path;
        }
    }

    public static void addAsShutdownHook() {
        Runtime.getRuntime().addShutdownHook(instance);
        if (log.isDebugEnabled()) {
            log.debug((Object)(instance + " registered as shutdown hook"));
        }
    }

    @Override
    public void run() {
        try {
            this.dumpMe();
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    @Override
    public void logMe() {
        try {
            ClasspathMonitor.logArray("BootClasspath", this.getBootClasspath());
            ClasspathMonitor.logArray("Classpath", this.getClasspath());
            ClasspathMonitor.logArray("ClasspathClasses", this.getClasspathClasses());
            ClasspathMonitor.logArray("DoubletClasspath", this.getDoubletClasspath());
            ClasspathMonitor.logArray("Doublets", this.getDoublets());
            ClasspathMonitor.logArray("LoadedClasses", this.getLoadedClasses());
            ClasspathMonitor.logArray("LoadedPackages", this.getLoadedPackages());
            ClasspathMonitor.logArray("UnusedClasses", this.getUnusedClasses());
            ClasspathMonitor.logArray("UnusedClasspath", this.getUnusedClasspath());
            ClasspathMonitor.logArray("UsedClasspath", this.getUsedClasspath());
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    private static void logArray(String title, String[] array) {
        log.info((Object)("=== " + title + " ==="));
        int i = 0;
        while (i < array.length) {
            log.info((Object)array[i]);
            ++i;
        }
    }

    @Override
    public void dumpMe() {
        try {
            try {
                File dumpFile = File.createTempFile("cpmon", ".txt");
                BufferedWriter writer = new BufferedWriter(new FileWriter(dumpFile));
                ClasspathMonitor.dumpArray(writer, "BootClasspath", this.getBootClasspath());
                ClasspathMonitor.dumpArray(writer, "Classpath", this.getClasspath());
                ClasspathMonitor.dumpArray(writer, "ClasspathClasses", this.getClasspathClasses());
                ClasspathMonitor.dumpArray(writer, "DoubletClasspath", this.getDoubletClasspath());
                ClasspathMonitor.dumpArray(writer, "Doublets", this.getDoublets());
                ClasspathMonitor.dumpArray(writer, "LoadedClasses", this.getLoadedClasses());
                ClasspathMonitor.dumpArray(writer, "LoadedPackages", this.getLoadedPackages());
                ClasspathMonitor.dumpArray(writer, "UnusedClasses", this.getUnusedClasses());
                ClasspathMonitor.dumpArray(writer, "UnusedClasspath", this.getUnusedClasspath());
                ClasspathMonitor.dumpArray(writer, "UsedClasspath", this.getUsedClasspath());
                writer.close();
                log.info((Object)("ClasspathMonitor attributes dumped to " + dumpFile));
            }
            catch (IOException ioe) {
                log.info((Object)("can't dump ClasspathMonitor attributes (" + ioe + ")"));
            }
            return;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    private static void dumpArray(BufferedWriter writer, String title, String[] array) throws IOException {
        writer.write("=== ");
        writer.write(title);
        writer.write(" ===");
        writer.newLine();
        int i = 0;
        while (i < array.length) {
            writer.write(array[i]);
            writer.newLine();
            ++i;
        }
        writer.newLine();
    }

    @Override
    public String toString() {
        try {
            return String.valueOf(this.getClass().getSimpleName()) + " for " + this.cloader;
        }
        catch (Throwable throwable) {
            if (this.getClass().isAnnotationPresent(LogThrowable.class) || this.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(this.getClass().getAnnotation(LogThrowable.class), throwable, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this));
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws JMException {
        ClasspathMonitor.registerAsMBean();
        ThreadUtil.sleep(300, TimeUnit.SECONDS);
    }

    private static final /* synthetic */ String[] createClasspathClasses_aroundBody0(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            Set<String> classSet = this_.unusedClasses;
            String[] classpathClasses = new String[classSet.size()];
            classSet.toArray(classpathClasses);
            return classpathClasses;
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object createClasspathClasses_aroundBody1$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            String[] stringArray = ClasspathMonitor.createClasspathClasses_aroundBody0(this_, ajc_aroundClosure);
            return stringArray;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ URI whichResource_aroundBody2(ClasspathMonitor this_, String name, JoinPoint joinPoint) {
        try {
            URL classUrl = ClasspathMonitor.class.getResource(name);
            if (classUrl == null) {
                if (!name.startsWith("/")) {
                    return this_.whichResource("/" + name);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)(String.valueOf(name) + " not found in classpath"));
                }
                return null;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("using " + classUrl + " for " + name));
            }
            try {
                return classUrl.toURI();
            }
            catch (URISyntaxException canthappen) {
                String msg = "can't convert " + classUrl + " to URI";
                log.error((Object)msg, (Throwable)canthappen);
                throw new RuntimeException(canthappen);
            }
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object whichResource_aroundBody3$advice(ClasspathMonitor this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, AbstractProfileAspect abstractProfileAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void mon;
            void var10_8 = mon;
            URI uRI = ClasspathMonitor.whichResource_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
            return uRI;
        }
        finally {
            void sig;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log((AbstractProfileAspect)sig, joinPoint, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ URI whichResource_aroundBody4(ClasspathMonitor this_, String name, ClassLoader classloader, JoinPoint joinPoint) {
        try {
            assert (classloader != null) : "no classloader given";
            URL url = classloader.getResource(name);
            if (url == null) {
                if (name.startsWith("/")) {
                    return this_.whichResource(name.substring(1));
                }
                return null;
            }
            try {
                return new URI(url.toString());
            }
            catch (URISyntaxException canthappen) {
                String msg = "can't convert " + url + " to URI";
                log.error((Object)msg, (Throwable)canthappen);
                throw new RuntimeException(canthappen);
            }
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object whichResource_aroundBody5$advice(ClasspathMonitor this_, String ajc_aroundClosure, ClassLoader thisJoinPoint, JoinPoint joinPoint, AbstractProfileAspect abstractProfileAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        Signature signature = joinPoint2.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            AroundClosure aroundClosure2 = aroundClosure;
            URI uRI = ClasspathMonitor.whichResource_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)sig);
            return uRI;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log((AbstractProfileAspect)mon, joinPoint2, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ URI whichClass_aroundBody6(ClasspathMonitor this_, String name, JoinPoint joinPoint) {
        try {
            String resource = Converter.classToResource(name);
            return this_.whichResource(resource);
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object whichClass_aroundBody7$advice(ClasspathMonitor this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, AbstractProfileAspect abstractProfileAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void mon;
            void var10_8 = mon;
            URI uRI = ClasspathMonitor.whichClass_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
            return uRI;
        }
        finally {
            void sig;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log((AbstractProfileAspect)sig, joinPoint, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ URI whichClass_aroundBody8(ClasspathMonitor this_, Class clazz, JoinPoint joinPoint) {
        try {
            return this_.whichClass(clazz.getName());
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object whichClass_aroundBody9$advice(ClasspathMonitor this_, Class ajc_aroundClosure, JoinPoint thisJoinPoint, AbstractProfileAspect abstractProfileAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void mon;
            void var10_8 = mon;
            URI uRI = ClasspathMonitor.whichClass_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
            return uRI;
        }
        finally {
            void sig;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log((AbstractProfileAspect)sig, joinPoint, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ Enumeration getResources_aroundBody10(ClasspathMonitor this_, String name, JoinPoint joinPoint) {
        try {
            try {
                Enumeration<URL> resources = this_.cloader.getResources(name);
                if (!resources.hasMoreElements()) {
                    if (name.startsWith("/")) {
                        return this_.getResources(name.substring(1));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(String.valueOf(name) + " not found in classpath"));
                    }
                }
                return resources;
            }
            catch (IOException ioe) {
                log.info((Object)(String.valueOf(name) + " not found in classpath"), (Throwable)ioe);
                return null;
            }
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getResources_aroundBody11$advice(ClasspathMonitor this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, AbstractProfileAspect abstractProfileAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void mon;
            void var10_8 = mon;
            Enumeration enumeration = ClasspathMonitor.getResources_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint);
            return enumeration;
        }
        finally {
            void sig;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log((AbstractProfileAspect)sig, joinPoint, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ int getNoResources_aroundBody12(ClasspathMonitor this_, String name, JoinPoint joinPoint) {
        try {
            Enumeration<URL> resources = this_.getResources(name);
            if (resources == null) {
                return 0;
            }
            int n = 0;
            while (resources.hasMoreElements()) {
                ++n;
                resources.nextElement();
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)(String.valueOf(n) + " element(s) of " + name + " found in classpath"));
            }
            return n;
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getNoResources_aroundBody13$advice(ClasspathMonitor this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, AbstractProfileAspect abstractProfileAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void mon;
            void var10_8 = mon;
            Object object = Conversions.intObject((int)ClasspathMonitor.getNoResources_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint));
            return object;
        }
        finally {
            void sig;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log((AbstractProfileAspect)sig, joinPoint, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ boolean isDoublet_aroundBody14(ClasspathMonitor this_, String name, JoinPoint joinPoint) {
        try {
            Enumeration<URL> resources = this_.getResources(name);
            if (resources == null || !resources.hasMoreElements()) {
                throw new NoSuchElementException(name);
            }
            resources.nextElement();
            if (resources.hasMoreElements()) {
                this_.logDoublets(name);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object isDoublet_aroundBody15$advice(ClasspathMonitor this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, AbstractProfileAspect abstractProfileAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void mon;
            void var10_8 = mon;
            Object object = Conversions.booleanObject((boolean)ClasspathMonitor.isDoublet_aroundBody14(this_, ajc_aroundClosure, thisJoinPoint));
            return object;
        }
        finally {
            void sig;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log((AbstractProfileAspect)sig, joinPoint, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ boolean isDoublet_aroundBody16(ClasspathMonitor this_, Class clazz, JoinPoint joinPoint) {
        try {
            String classname = clazz.getName();
            String resource = Converter.classToResource(classname);
            return this_.isDoublet(resource);
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object isDoublet_aroundBody17$advice(ClasspathMonitor this_, Class ajc_aroundClosure, JoinPoint thisJoinPoint, AbstractProfileAspect abstractProfileAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void mon;
            void var10_8 = mon;
            Object object = Conversions.booleanObject((boolean)ClasspathMonitor.isDoublet_aroundBody16(this_, ajc_aroundClosure, thisJoinPoint));
            return object;
        }
        finally {
            void sig;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log((AbstractProfileAspect)sig, joinPoint, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ List getDoubletList_aroundBody18(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            List<Class<?>> loadedClassList = this_.getLoadedClassList();
            for (Class<?> clazz : loadedClassList) {
                if (this_.doubletList.contains(clazz)) continue;
                try {
                    if (!this_.isDoublet(clazz)) continue;
                    this_.doubletList.add(clazz);
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)(clazz + " not found -> ignored"));
                }
            }
            Collections.sort(this_.doubletList, new ObjectComparator());
            return this_.doubletList;
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getDoubletList_aroundBody19$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            List list = ClasspathMonitor.getDoubletList_aroundBody18(this_, ajc_aroundClosure);
            return list;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ String[] getDoublets_aroundBody20(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            log.debug((Object)"calculating doublets...");
            List<Class<?>> doubletList = this_.getDoubletList();
            String[] doublets = new String[doubletList.size()];
            int i = 0;
            while (i < doublets.length) {
                doublets[i] = doubletList.get(i).toString();
                ++i;
            }
            return doublets;
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getDoublets_aroundBody21$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            String[] stringArray = ClasspathMonitor.getDoublets_aroundBody20(this_, ajc_aroundClosure);
            return stringArray;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ String[] getDoubletClasspath_aroundBody22(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            log.debug((Object)"calculating doublet-classpath...");
            SortedSet<URI> classpathSet = this_.getDoubletClasspathSet();
            return ClasspathMonitor.getAsArray(classpathSet);
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getDoubletClasspath_aroundBody23$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            String[] stringArray = ClasspathMonitor.getDoubletClasspath_aroundBody22(this_, ajc_aroundClosure);
            return stringArray;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ SortedSet getDoubletClasspathSet_aroundBody24(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            List<Class<?>> doubletList = this_.getDoubletList();
            TreeSet<URI> classpath = new TreeSet<URI>();
            for (Class<?> cl : doubletList) {
                String resource = Converter.classToResource(cl);
                Enumeration<URL> resources = this_.getResources(resource);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    try {
                        URI path = url.toURI();
                        classpath.add(ClasspathMonitor.getParent(path, resource));
                    }
                    catch (URISyntaxException canthappen) {
                        log.debug((Object)("can't convert " + url + " to URI"), (Throwable)canthappen);
                    }
                }
            }
            return classpath;
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getDoubletClasspathSet_aroundBody25$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            SortedSet sortedSet = ClasspathMonitor.getDoubletClasspathSet_aroundBody24(this_, ajc_aroundClosure);
            return sortedSet;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ String getClassLoaderDetails_aroundBody26(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            StringBuffer sbuf = new StringBuffer("dump of " + this_.cloader + ":\n");
            Class<?> cl = this_.cloader.getClass();
            while (cl != null) {
                sbuf.append('\t');
                ClasspathMonitor.dumpFields(sbuf, cl, this_.cloader);
                cl = cl.getSuperclass();
            }
            return sbuf.toString().trim();
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getClassLoaderDetails_aroundBody27$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            String string = ClasspathMonitor.getClassLoaderDetails_aroundBody26(this_, ajc_aroundClosure);
            return string;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ void dumpFields_aroundBody28(StringBuffer sbuf, Class cl, Object obj, JoinPoint joinPoint) {
        AccessibleObject[] fields = cl.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        int i = 0;
        while (i < fields.length) {
            sbuf.append(fields[i]);
            sbuf.append(" = ");
            try {
                sbuf.append(((Field)fields[i]).get(obj));
            }
            catch (Exception e) {
                sbuf.append("<" + e + ">");
            }
            sbuf.append('\n');
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object dumpFields_aroundBody29$advice(StringBuffer this_, Class ajc_aroundClosure, Object thisJoinPoint, JoinPoint joinPoint, AbstractProfileAspect abstractProfileAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        Signature signature = joinPoint2.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            AroundClosure aroundClosure2 = aroundClosure;
            ClasspathMonitor.dumpFields_aroundBody28(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)sig);
            Object var10_10 = null;
            return var10_10;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log((AbstractProfileAspect)mon, joinPoint2, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ Package[] getLoadedPackageArray_aroundBody30(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            Method method = ClasspathMonitor.getMethod(this_.cloader.getClass(), "getPackages");
            if (method == null) {
                log.warn((Object)(this_.cloader.getClass() + "#getPackages() not found"));
                return null;
            }
            try {
                method.setAccessible(true);
                return (Package[])method.invoke((Object)this_.cloader, new Object[0]);
            }
            catch (Exception e) {
                log.warn((Object)("can't access " + method), (Throwable)e);
                return null;
            }
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getLoadedPackageArray_aroundBody31$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            Package[] packageArray = ClasspathMonitor.getLoadedPackageArray_aroundBody30(this_, ajc_aroundClosure);
            return packageArray;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ List getLoadedClassList_aroundBody32(ClassLoader cloader, JoinPoint joinPoint) {
        try {
            Field field = ReflectionHelper.getField(cloader.getClass(), "classes");
            List classList = (List)field.get(cloader);
            return new ArrayList(classList);
        }
        catch (Exception e) {
            log.warn((Object)"can't access field 'classes'", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getLoadedClassList_aroundBody33$advice(ClassLoader this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            List list = ClasspathMonitor.getLoadedClassList_aroundBody32(this_, ajc_aroundClosure);
            return list;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ List getLoadedClassList_aroundBody34(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            List<Class<?>> classlist = ClasspathMonitor.getLoadedClassList(this_.cloader);
            return classlist;
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getLoadedClassList_aroundBody35$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            List list = ClasspathMonitor.getLoadedClassList_aroundBody34(this_, ajc_aroundClosure);
            return list;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ String getLoadedClassesAsString_aroundBody36(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            List<Class<?>> classes = this_.getLoadedClassList();
            Collections.sort(classes, new ObjectComparator());
            StringBuffer sbuf = new StringBuffer();
            Iterator<Class<?>> i = classes.iterator();
            while (i.hasNext()) {
                sbuf.append(i.next().toString().trim());
                sbuf.append('\n');
            }
            return sbuf.toString().trim();
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getLoadedClassesAsString_aroundBody37$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            String string = ClasspathMonitor.getLoadedClassesAsString_aroundBody36(this_, ajc_aroundClosure);
            return string;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ String[] getUnusedClasses_aroundBody38(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            List<Class<?>> classes = this_.getLoadedClassList();
            ArrayList<String> used = new ArrayList<String>();
            for (Class<?> cl : classes) {
                String classname = cl.getName();
                if (!this_.unusedClasses.contains(classname)) continue;
                used.add(classname);
            }
            this_.unusedClasses.removeAll(used);
            String[] unused = new String[this_.unusedClasses.size()];
            this_.unusedClasses.toArray(unused);
            return unused;
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getUnusedClasses_aroundBody39$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            String[] stringArray = ClasspathMonitor.getUnusedClasses_aroundBody38(this_, ajc_aroundClosure);
            return stringArray;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ Set getClasspathClassSet_aroundBody40(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            TreeSet<String> classSet = new TreeSet<String>();
            int i = 0;
            while (i < this_.classpath.length) {
                ClasspathMonitor.addClasses(classSet, new File(this_.classpath[i]));
                ++i;
            }
            return classSet;
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getClasspathClassSet_aroundBody41$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            Set set = ClasspathMonitor.getClasspathClassSet_aroundBody40(this_, ajc_aroundClosure);
            return set;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ void addClassesFromDir_aroundBody42(Set classSet, File dir, JoinPoint joinPoint) {
        ClassWalker classWalker = new ClassWalker(dir);
        Collection<String> classes = classWalker.getClasses();
        classSet.addAll(classes);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object addClassesFromDir_aroundBody43$advice(Set this_, File ajc_aroundClosure, JoinPoint thisJoinPoint, AbstractProfileAspect abstractProfileAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void mon;
            void var10_8 = mon;
            ClasspathMonitor.addClassesFromDir_aroundBody42(this_, ajc_aroundClosure, thisJoinPoint);
            Object var9_9 = null;
            return var9_9;
        }
        finally {
            void sig;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log((AbstractProfileAspect)sig, joinPoint, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ void addClassesFromArchive_aroundBody44(Set classSet, File archive, JoinPoint joinPoint) {
        ZipFile zipFile = new ZipFile(archive);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            classSet.add(Converter.resourceToClass(name));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object addClassesFromArchive_aroundBody45$advice(Set this_, File ajc_aroundClosure, JoinPoint thisJoinPoint, AbstractProfileAspect abstractProfileAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void mon;
            void var10_8 = mon;
            ClasspathMonitor.addClassesFromArchive_aroundBody44(this_, ajc_aroundClosure, thisJoinPoint);
            Object var9_9 = null;
            return var9_9;
        }
        finally {
            void sig;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log((AbstractProfileAspect)sig, joinPoint, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ SortedSet getUsedClasspathSet_aroundBody46(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            List<Class<?>> loadedClassList = this_.getLoadedClassList();
            TreeSet<URI> usedClasspathSet = new TreeSet<URI>();
            for (Class<?> clazz : loadedClassList) {
                URI classUri = this_.whichClass(clazz);
                if (classUri == null) continue;
                URI classpath = ClasspathMonitor.getParent(classUri, clazz);
                usedClasspathSet.add(classpath);
            }
            return usedClasspathSet;
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getUsedClasspathSet_aroundBody47$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            SortedSet sortedSet = ClasspathMonitor.getUsedClasspathSet_aroundBody46(this_, ajc_aroundClosure);
            return sortedSet;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ String[] getUsedClasspath_aroundBody48(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            log.debug((Object)"calculating used classpath...");
            SortedSet<URI> classpathSet = this_.getUsedClasspathSet();
            return ClasspathMonitor.getAsArray(classpathSet);
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getUsedClasspath_aroundBody49$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            String[] stringArray = ClasspathMonitor.getUsedClasspath_aroundBody48(this_, ajc_aroundClosure);
            return stringArray;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ String[] getUnusedClasspath_aroundBody50(ClasspathMonitor this_, JoinPoint joinPoint) {
        try {
            log.debug((Object)"calculating unused classpath...");
            TreeSet<String> unused = new TreeSet<String>();
            String[] classpath = this_.getClasspath();
            log.trace((Object)(Arrays.class + " loaded (to get corrected used classpath"));
            Object[] used = this_.getUsedClasspath();
            int i = 0;
            while (i < classpath.length) {
                String path = classpath[i];
                if (Arrays.binarySearch(used, path) < 0) {
                    unused.add(path);
                }
                ++i;
            }
            String[] a = new String[unused.size()];
            return unused.toArray(a);
        }
        catch (Throwable throwable) {
            ClasspathMonitor classpathMonitor;
            if (classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class) || classpathMonitor.getClass().isAnnotationPresent(LogThrowable.class)) {
                LogThrowableAspect.aspectOf().ajc$afterThrowing$patterntesting_runtime_log_LogThrowableAspect$2$7afd5a2(classpathMonitor.getClass().getAnnotation(LogThrowable.class), throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getUnusedClasspath_aroundBody51$advice(ClasspathMonitor this_, JoinPoint ajc_aroundClosure, AbstractProfileAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void sig;
            void var9_7 = sig;
            String[] stringArray = ClasspathMonitor.getUnusedClasspath_aroundBody50(this_, ajc_aroundClosure);
            return stringArray;
        }
        finally {
            void mon;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log(thisJoinPoint, (JoinPoint)mon, profileMonitor.getLastValue());
        }
    }

    private static final /* synthetic */ URI getParent_aroundBody52(URI path, Class clazz, JoinPoint joinPoint) {
        String resource = Converter.classToResource(clazz);
        return ClasspathMonitor.getParent(path, resource);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getParent_aroundBody53$advice(URI this_, Class ajc_aroundClosure, JoinPoint thisJoinPoint, AbstractProfileAspect abstractProfileAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        ProfileMonitor profileMonitor = ProfileStatistic.start(signature);
        try {
            void mon;
            void var10_8 = mon;
            URI uRI = ClasspathMonitor.getParent_aroundBody52(this_, ajc_aroundClosure, thisJoinPoint);
            return uRI;
        }
        finally {
            void sig;
            profileMonitor.stop();
            AbstractProfileAspect.ajc$inlineAccessMethod$patterntesting_runtime_monitor_AbstractProfileAspect$patterntesting_runtime_monitor_AbstractProfileAspect$log((AbstractProfileAspect)sig, joinPoint, profileMonitor.getLastValue());
        }
    }
}

