/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import patterntesting.runtime.annotation.LogThrowable;
import patterntesting.runtime.log.LogRecorder;
import patterntesting.runtime.log.LogThrowableAspect;

@LogThrowable
public class LogThrowableTest {
    private static final Log log = LogFactoryImpl.getLog(LogThrowableTest.class);
    private static Log aspectLog = LogThrowableAspect.log;
    private LogRecorder testLog;
    static /* synthetic */ Class class$0;

    @Before
    public void setUp() {
        this.testLog = new LogRecorder();
        LogThrowableAspect.log = this.testLog;
    }

    @AfterClass
    public static void tearDownAfterClass() {
        LogThrowableAspect.log = aspectLog;
    }

    @Test
    public void testLog() {
        try {
            this.throwRuntimeException("do you see me?");
            Assert.fail((String)"RuntimeException expected");
        }
        catch (RuntimeException runtimeException) {
            this.checkLog("RuntimeException in throwRuntimeException(\"do you see me?\")");
        }
    }

    @Test
    public void testLogNPE() {
        try {
            this.throwNullPointerException(null);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (RuntimeException runtimeException) {
            this.checkLog("NullPointerException in throwNullPointerException((null))");
        }
    }

    @LogThrowable(value=3)
    private void throwRuntimeException(String msg) {
        throw new RuntimeException(msg);
    }

    private void throwNullPointerException(String s) {
        s.length();
    }

    @Test
    public final void testLogAssertionError() {
        String s = "provocated error";
        try {
            this.throwAssertionError(s);
        }
        catch (AssertionError expected) {
            log.info((Object)expected);
            this.checkLog("AssertionError in throwAssertionError(\"" + s + "\")");
        }
    }

    private void throwAssertionError(String s) {
        Assert.fail((String)s);
    }

    private void checkLog(String expected) {
        LogThrowableTest.checkLog(this.testLog, expected);
    }

    protected static void checkLog(LogRecorder testLog, String expected) {
        log.debug((Object)testLog.getRecord());
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)testLog.getRecord()));
        Assert.assertEquals((long)1L, (long)testLog.getNumberOfRecords());
        Assert.assertEquals((Object)expected, (Object)testLog.getText());
    }
}

