/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.log;

import org.apache.commons.logging.Log;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import patterntesting.runtime.annotation.LogRuntimeException;
import patterntesting.runtime.log.LogRecorder;
import patterntesting.runtime.log.LogRuntimeExceptionAspect;
import patterntesting.runtime.log.LogThrowableTest;

@LogRuntimeException
public class LogRuntimeExceptionTest {
    private static Log aspectLog = LogRuntimeExceptionAspect.log;
    private LogRecorder testLog;

    @Before
    public void setUp() {
        this.testLog = new LogRecorder();
        LogRuntimeExceptionAspect.log = this.testLog;
    }

    @AfterClass
    public static void tearDownAfterClass() {
        LogRuntimeExceptionAspect.log = aspectLog;
    }

    @Test
    public void testLog() {
        try {
            this.throwRuntimeException("do you see me?");
            Assert.fail((String)"RuntimeException expected");
        }
        catch (RuntimeException runtimeException) {
            this.checkLog("RuntimeException in throwRuntimeException(\"do you see me?\")");
        }
    }

    @Test
    public void testLogNPE() {
        try {
            this.throwNullPointerException(null);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (RuntimeException runtimeException) {
            this.checkLog("NullPointerException in throwNullPointerException((null))");
        }
    }

    @LogRuntimeException(value=3)
    private void throwRuntimeException(String msg) {
        throw new RuntimeException(msg);
    }

    private void throwNullPointerException(String s) {
        s.length();
    }

    private void checkLog(String expected) {
        LogThrowableTest.checkLog(this.testLog, expected);
    }
}

